// Load Wi-Fi library
#include <WiFi.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BME280.h>

#define SEALEVELPRESSURE_HPA (1013.25)
#define LIGHTSENSORPIN 34 //Valosensori pinnissä 34

Adafruit_BME280 bme; //BME280 esittely
int reading;
byte sensorPin = 27;  //liikesensorin esittely

// ESP-tukiaseman ssid ja salasana
const char* ssid     = "NellinAP";
const char* password = "12332121";

// Set web server port number to 80
WiFiServer server(80);

// Variable to store the HTTP request
String header;

void setup() {
  Serial.begin(115200);
  pinMode(LIGHTSENSORPIN, INPUT);
  byte sensorPin = 27; //liikesensorin aktivointi

  // Connect to Wi-Fi network with SSID and password
  Serial.print("Connecting to ");
  Serial.println(ssid);
  WiFi.softAP(ssid, password);

  // Print local IP address and start web server
  Serial.println("");
  Serial.println("WiFi connected.");
  Serial.println("IP address: ");
  Serial.println(WiFi.softAPIP());
  server.begin();

  //BME280 käynnistys
  while(!Serial);
  Serial.println(F("BME280 test"));
  bme.begin();
}

void loop(){
  WiFiClient client = server.available();   // Listen for incoming clients

  if (client) {                             // If a new client connects,
    Serial.println("New Client.");          // print a message out in the serial port
    String currentLine = "";                // make a String to hold incoming data from the client
    while (client.connected()) {            // loop while the client's connected
      if (client.available()) {             // if there's bytes to read from the client,
        char c = client.read();             // read a byte, then
        Serial.write(c);                    // print it out the serial monitor
        header += c;
        if (c == '\n') {                    // if the byte is a newline character
          // if the current line is blank, you got two newline characters in a row.
          // that's the end of the client HTTP request, so send a response:
          if (currentLine.length() == 0) {
            // HTTP headers always start with a response code (e.g. HTTP/1.1 200 OK)
            // and a content-type so the client knows what's coming, then a blank line:
            client.println("HTTP/1.1 200 OK");
            client.println("Content-type:text/html");
            client.println("Connection: close");
            client.println();
            
            // Display the HTML web page
            client.println("<!DOCTYPE html><html>");
            client.println("<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
            client.println("<link rel=\"icon\" href=\"data:,\">");
           
            // CSS to style

            // Web Page Heading
            client.println("</head><body><center><h1>ESP32 Mittaukset</h1>");

            //lämpötilan tulostus asiakkaalle
            client.println("<table><tr><td>");
            client.println("L&aumlmp&oumltila");
            client.println("</td><td>");
            client.println(bme.readTemperature());
            client.println("  &degC");
            client.println("</td></tr>");

            //kosteuden tulostus asiakkaalle
            client.println("<tr><td>");
            client.println("Kosteus");
            client.println("</td><td>");
            client.println(bme.readHumidity());
            client.println(" %");
            client.println("</td></tr>");
            
            //paineen tulostus asiakkaalle
            client.println("<tr><td>");
            client.println("Paine");
            client.println("</td><td>");
            client.println(bme.readPressure()/100.0F);
            client.println(" mbar");
            client.println("</td></tr>");

            //valoisuuden tulostus asiakkaalle
            client.println("<tr><td>");
            client.println("Valoisuus ");
            client.println("</td><td>");
            client.println(analogRead(LIGHTSENSORPIN));
            client.println(" lux");  
            client.println("</td></tr>");
            
            //liikesensorin tietojen tulostus asiakkaalle
            client.println("<tr><td>");
            client.println("Paikalla? ");
            client.println("</td><td>");
            byte state = digitalRead(sensorPin);
            if (state == 1)client.println("KYLLÄ");
            else if (state == 0)client.println("EI");
            client.println("</td></tr>");
            client.println("</table>");

            //update-nappula
            client.println("<p></p>");
            client.println("<button onclick=location=URL>UPDATE</button>");
            client.println("</center></body></html>");
            
            // The HTTP response ends with another blank line
            client.println();
            // Break out of the while loop
            break;
          } else { // if you got a newline, then clear currentLine
            currentLine = "";
          }
        } else if (c != '\r') {  // if you got anything else but a carriage return character,
          currentLine += c;      // add it to the end of the currentLine
        }
      }
    }
    // Clear the header variable
    header = "";
    // Close the connection
    client.stop();
    Serial.println("Client disconnected.");
    Serial.println("");
  }
}
