/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public final class RectangleAnchor
implements Serializable {
    public static final RectangleAnchor CENTER = new RectangleAnchor("RectangleAnchor.CENTER");
    public static final RectangleAnchor TOP = new RectangleAnchor("RectangleAnchor.TOP");
    public static final RectangleAnchor TOP_LEFT = new RectangleAnchor("RectangleAnchor.TOP_LEFT");
    public static final RectangleAnchor TOP_RIGHT = new RectangleAnchor("RectangleAnchor.TOP_RIGHT");
    public static final RectangleAnchor BOTTOM = new RectangleAnchor("RectangleAnchor.BOTTOM");
    public static final RectangleAnchor BOTTOM_LEFT = new RectangleAnchor("RectangleAnchor.BOTTOM_LEFT");
    public static final RectangleAnchor BOTTOM_RIGHT = new RectangleAnchor("RectangleAnchor.BOTTOM_RIGHT");
    public static final RectangleAnchor LEFT = new RectangleAnchor("RectangleAnchor.LEFT");
    public static final RectangleAnchor RIGHT = new RectangleAnchor("RectangleAnchor.RIGHT");
    private String name;

    private RectangleAnchor(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RectangleAnchor)) {
            return false;
        }
        RectangleAnchor order = (RectangleAnchor)obj;
        return this.name.equals(order.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static Point2D coordinates(Rectangle2D rectangle, RectangleAnchor anchor) {
        Point2D.Double result = new Point2D.Double();
        if (anchor == CENTER) {
            ((Point2D)result).setLocation(rectangle.getCenterX(), rectangle.getCenterY());
        } else if (anchor == TOP) {
            ((Point2D)result).setLocation(rectangle.getCenterX(), rectangle.getMinY());
        } else if (anchor == BOTTOM) {
            ((Point2D)result).setLocation(rectangle.getCenterX(), rectangle.getMaxY());
        } else if (anchor == LEFT) {
            ((Point2D)result).setLocation(rectangle.getMinX(), rectangle.getCenterY());
        } else if (anchor == RIGHT) {
            ((Point2D)result).setLocation(rectangle.getMaxX(), rectangle.getCenterY());
        } else if (anchor == TOP_LEFT) {
            ((Point2D)result).setLocation(rectangle.getMinX(), rectangle.getMinY());
        } else if (anchor == TOP_RIGHT) {
            ((Point2D)result).setLocation(rectangle.getMaxX(), rectangle.getMinY());
        } else if (anchor == BOTTOM_LEFT) {
            ((Point2D)result).setLocation(rectangle.getMinX(), rectangle.getMaxY());
        } else if (anchor == BOTTOM_RIGHT) {
            ((Point2D)result).setLocation(rectangle.getMaxX(), rectangle.getMaxY());
        }
        return result;
    }
}

