/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.net.URLEncoder;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.ObjectUtilities;

public class StandardCategoryURLGenerator
implements Serializable,
Cloneable,
CategoryURLGenerator {
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String categoryParameterName = "category";

    public String generateURL(CategoryDataset dataset, int series, int category) {
        String url = this.prefix;
        Comparable seriesKey = dataset.getRowKey(series);
        Comparable categoryKey = dataset.getColumnKey(category);
        boolean firstParameter = url.indexOf("?") == -1;
        url = url + (firstParameter ? "?" : "&amp;");
        url = url + this.seriesParameterName + "=" + URLEncoder.encode(seriesKey.toString());
        url = url + "&amp;" + this.categoryParameterName + "=" + URLEncoder.encode(categoryKey.toString());
        return url;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardCategoryURLGenerator)) {
            return false;
        }
        StandardCategoryURLGenerator that = (StandardCategoryURLGenerator)obj;
        if (!ObjectUtilities.equal(this.prefix, that.prefix)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesParameterName, that.seriesParameterName)) {
            return false;
        }
        return ObjectUtilities.equal(this.categoryParameterName, that.categoryParameterName);
    }

    public int hashCode() {
        int result = this.prefix != null ? this.prefix.hashCode() : 0;
        result = 29 * result + (this.seriesParameterName != null ? this.seriesParameterName.hashCode() : 0);
        result = 29 * result + (this.categoryParameterName != null ? this.categoryParameterName.hashCode() : 0);
        return result;
    }
}

