/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.colorado.phet.nuclearphysics.common.NucleusDisplayInfo;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;

public abstract class LabeledNucleusNode
extends PComposite {
    private final PNode _labelLayer;
    private final PNode _representationLayer = new PNode();
    private final ShadowHTMLNode _label;

    public LabeledNucleusNode(String string, String string2, Color color) {
        this.addChild(this._representationLayer);
        this._labelLayer = new PNode();
        this.addChild(this._labelLayer);
        String string3 = "<html><sup><font size=-2>" + string + " </font></sup>" + string2 + "</html>";
        this._label = new ShadowHTMLNode(string3);
        this._label.setColor(color);
        this._label.setShadowColor(color == Color.BLACK ? Color.WHITE : Color.BLACK);
        this._label.setShadowOffset(0.5, 0.5);
        this._labelLayer.addChild(this._label);
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    public LabeledNucleusNode(NucleusDisplayInfo nucleusDisplayInfo) {
        this.addChild(this._representationLayer);
        this._labelLayer = new PNode();
        this.addChild(this._labelLayer);
        String string = nucleusDisplayInfo.getIsotopeNumberString();
        String string2 = nucleusDisplayInfo.getChemicalSymbol();
        Color color = nucleusDisplayInfo.getLabelColor();
        String string3 = "<html><sup><font size=-2>" + string + " </font></sup>" + string2 + "</html>";
        this._label = new ShadowHTMLNode(string3);
        this._label.setColor(color);
        this._label.setShadowColor(color == Color.BLACK ? Color.WHITE : Color.BLACK);
        this._label.setShadowOffset(0.5, 0.5);
        this._labelLayer.addChild(this._label);
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    public ShadowHTMLNode getLabel() {
        return this._label;
    }

    protected PNode getRepresentationLayer() {
        return this._representationLayer;
    }

    protected Color getHighlightColor(Color color) {
        Color color2;
        int n = Math.max(Math.max(color.getRed(), color.getGreen()), color.getBlue());
        if (n > 225) {
            color2 = Color.WHITE;
        } else {
            int n2 = color.getRed() + (255 - color.getRed()) * 3 / 4;
            int n3 = color.getGreen() + (255 - color.getGreen()) * 3 / 4;
            int n4 = color.getBlue() + (255 - color.getBlue()) * 3 / 4;
            color2 = new Color(n2, n3, n4);
        }
        return color2;
    }
}

