/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.view.AbstractAtomicNucleusNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicSliderUI;

public class BucketOfNucleiNode
extends PNode {
    private static final Stroke LINE_STROKE = new BasicStroke(0.5f);
    private static final Color DEFAULT_COLOR = new Color(0xFFAA00);
    private ArrayList _listeners = new ArrayList();
    private PPath _bucketRect;
    private PNode _backOfBucketLayer;
    private PNode _backInteriorLayer;
    private PNode _middleInteriorLayer;
    private PNode _frontInteriorLayer;
    private PNode _frontOfBucketLayer;
    private HTMLNode _bucketLabel;
    private PImage _radiationSymbolNode;
    private AbstractAtomicNucleusNode[] _visibleNucleusNodes;
    private double _bucketHeight;
    private double _bucketWidth;
    private double _ellipseVerticalSpan;
    int _numVisibleNucleiInMiddleLayer;
    int _numVisibleNucleiInOuterLayers;
    ArrayList _shrinkAnimationTimers;
    private NucleusType _nucleusType;
    private double _nucleusWidth = 0.0;
    private boolean _showLabel = true;
    private boolean _showRadiationSymbol = true;
    private PSwing _sliderNode = null;
    private NormalizedSlider _slider;

    public BucketOfNucleiNode(double d, double d2, double d3, Color color) {
        this._bucketHeight = d2;
        this._bucketWidth = d;
        this._shrinkAnimationTimers = new ArrayList();
        this._nucleusType = NucleusType.POLONIUM_211;
        this._bucketRect = new PPath(new Rectangle2D.Double(0.0, 0.0, d, d2));
        this._bucketRect.setPaint(Color.BLUE);
        this._bucketRect.setVisible(false);
        this.addChild(this._bucketRect);
        this._ellipseVerticalSpan = d2 * d3 * 0.6366197723675814;
        Color color2 = color;
        Color color3 = ColorUtils.darkerColor(color, 0.5);
        Color color4 = ColorUtils.darkerColor(color3, 0.5);
        Color color5 = color3;
        GradientPaint gradientPaint = new GradientPaint(0.0f, (float)d2 / 2.0f, color3, (float)d, (float)d2 / 2.0f, color2);
        GradientPaint gradientPaint2 = new GradientPaint(0.0f, (float)d2 / 2.0f, color5, (float)d, (float)d2 / 2.0f, color4);
        this._backOfBucketLayer = new PNode();
        this.addChild(this._backOfBucketLayer);
        this._backInteriorLayer = new PNode();
        this.addChild(this._backInteriorLayer);
        this._middleInteriorLayer = new PNode();
        this.addChild(this._middleInteriorLayer);
        this._frontInteriorLayer = new PNode();
        this.addChild(this._frontInteriorLayer);
        this._frontOfBucketLayer = new PNode();
        this.addChild(this._frontOfBucketLayer);
        PhetPPath phetPPath = new PhetPPath(new Ellipse2D.Double(0.0, 0.0, d, this._ellipseVerticalSpan));
        phetPPath.setStroke(LINE_STROKE);
        phetPPath.setPaint(gradientPaint2);
        this._backOfBucketLayer.addChild(phetPPath);
        double d4 = this._ellipseVerticalSpan * 0.85;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, (float)(this._ellipseVerticalSpan / 2.0));
        generalPath.lineTo((float)(d * 0.1), (float)(d2 - d4 / 2.0));
        generalPath.quadTo((float)(d / 2.0), (float)(d2 + this._ellipseVerticalSpan * 0.4), (float)(d * 0.9), (float)(d2 - d4 / 2.0));
        generalPath.lineTo((float)d, (float)(this._ellipseVerticalSpan / 2.0));
        generalPath.quadTo((float)(d / 2.0), (float)(this._ellipseVerticalSpan * 1.5), 0.0f, (float)(this._ellipseVerticalSpan / 2.0));
        generalPath.closePath();
        PhetPPath phetPPath2 = new PhetPPath(generalPath);
        phetPPath2.setStroke(LINE_STROKE);
        phetPPath2.setPaint(gradientPaint);
        this._frontOfBucketLayer.addChild(phetPPath2);
        this._bucketLabel = new HTMLNode();
        this._bucketLabel.setFont(new PhetFont(12));
        this._frontOfBucketLayer.addChild(this._bucketLabel);
        this.updateLabelText();
        this._radiationSymbolNode = NuclearPhysicsResources.getImageNode("RadiationSymbolWithPerspective.png");
        this._radiationSymbolNode.scale(0.28 * (this._bucketHeight / this._radiationSymbolNode.getWidth()));
        this._radiationSymbolNode.setOffset(this._bucketWidth * 0.75, this._bucketHeight * 0.4);
        this._frontOfBucketLayer.addChild(this._radiationSymbolNode);
        PhetPPath phetPPath3 = new PhetPPath(new QuadCurve2D.Double(d / 2.0, this._ellipseVerticalSpan, d * 1.6, this._ellipseVerticalSpan * 1.3, d, this._ellipseVerticalSpan / 2.0));
        phetPPath3.setStroke(LINE_STROKE);
        this._frontOfBucketLayer.addChild(phetPPath3);
    }

    public BucketOfNucleiNode(double d, double d2) {
        this(d, d2, 0.5235987755982988, DEFAULT_COLOR);
    }

    public BucketOfNucleiNode(double d, double d2, Color color) {
        this(d, d2, 0.5235987755982988, color);
    }

    public void addNucleus(AbstractAtomicNucleusNode abstractAtomicNucleusNode) {
        if (this.isEmpty()) {
            this._nucleusWidth = abstractAtomicNucleusNode.getFullBoundsReference().getWidth();
            this._numVisibleNucleiInMiddleLayer = (int)(this._bucketWidth / this._nucleusWidth);
            this._numVisibleNucleiInOuterLayers = (int)((double)this._numVisibleNucleiInMiddleLayer * 0.75);
            this._visibleNucleusNodes = new AbstractAtomicNucleusNode[2 * this._numVisibleNucleiInOuterLayers + this._numVisibleNucleiInMiddleLayer];
        }
        boolean bl = false;
        for (int i = 0; i < this._visibleNucleusNodes.length; ++i) {
            if (this._visibleNucleusNodes[i] != null) continue;
            abstractAtomicNucleusNode.setVisible(true);
            this._visibleNucleusNodes[i] = abstractAtomicNucleusNode;
            this.positionVisibleNucleus(i);
            bl = true;
            break;
        }
        if (!bl) {
            abstractAtomicNucleusNode.setVisible(false);
            this.addChild(abstractAtomicNucleusNode);
        }
    }

    public void addNucleusAnimated(AbstractAtomicNucleusNode abstractAtomicNucleusNode) {
        this._shrinkAnimationTimers.add(new ShrinkAnimationTimer(abstractAtomicNucleusNode));
    }

    public void removeNucleus(AbstractAtomicNucleusNode abstractAtomicNucleusNode) {
        int n;
        boolean bl = false;
        for (n = 0; n < this._visibleNucleusNodes.length; ++n) {
            if (this._visibleNucleusNodes[n] != abstractAtomicNucleusNode) continue;
            bl = true;
            this._visibleNucleusNodes[n] = null;
            if (this._backInteriorLayer.isAncestorOf(abstractAtomicNucleusNode)) {
                this._backInteriorLayer.removeChild(abstractAtomicNucleusNode);
                break;
            }
            if (this._middleInteriorLayer.isAncestorOf(abstractAtomicNucleusNode)) {
                this._middleInteriorLayer.removeChild(abstractAtomicNucleusNode);
                break;
            }
            if (!this._frontInteriorLayer.isAncestorOf(abstractAtomicNucleusNode)) break;
            this._frontInteriorLayer.removeChild(abstractAtomicNucleusNode);
            break;
        }
        if (bl) {
            this.fillEmptyVisibleSlots();
        } else if (this.isAncestorOf(abstractAtomicNucleusNode)) {
            this.removeChild(abstractAtomicNucleusNode);
        } else {
            n = 0;
            for (int i = 0; i < this._shrinkAnimationTimers.size(); ++i) {
                ShrinkAnimationTimer shrinkAnimationTimer = (ShrinkAnimationTimer)this._shrinkAnimationTimers.get(i);
                if (shrinkAnimationTimer.getShrinkingNode() != abstractAtomicNucleusNode) continue;
                shrinkAnimationTimer.stop();
                shrinkAnimationTimer.clearShrinkingNode();
                this._shrinkAnimationTimers.remove(shrinkAnimationTimer);
                n = 1;
                break;
            }
            if (n == 0) {
                System.err.println("Warning: Unable to locate and remove node.");
            }
        }
    }

    public AbstractAtomicNucleusNode extractAnyNucleusFromBucket() {
        AbstractAtomicNucleusNode abstractAtomicNucleusNode = null;
        for (int i = 0; i < this._visibleNucleusNodes.length; ++i) {
            if (this._visibleNucleusNodes[i] == null) continue;
            abstractAtomicNucleusNode = this._visibleNucleusNodes[i];
            this._visibleNucleusNodes[i] = null;
            break;
        }
        if (abstractAtomicNucleusNode != null) {
            this.fillEmptyVisibleSlots();
        }
        return abstractAtomicNucleusNode;
    }

    public boolean isNodeInBucket(PNode pNode) {
        return this.isAncestorOf(pNode);
    }

    public void setNucleusType(NucleusType nucleusType) {
        this._nucleusType = nucleusType;
        this.updateLabelText();
    }

    public void setShowLabel(boolean bl) {
        this._showLabel = bl;
        this.updateLabelText();
    }

    public void setShowRadiationSymbol(boolean bl) {
        this._showRadiationSymbol = bl;
        this._radiationSymbolNode.setVisible(this._showRadiationSymbol);
    }

    public void setSliderEnabled(boolean bl) {
        if (this._sliderNode == null && bl) {
            this._slider = new NormalizedSlider();
            this._slider.setPreferredSize(new Dimension((int)(this._bucketWidth * 0.5), (int)(this._bucketHeight * 0.5)));
            this._slider.setOpaque(false);
            this._slider.setForeground(Color.GREEN);
            this._slider.setCursor(new Cursor(12));
            this._sliderNode = new PSwing(this._slider);
            this._sliderNode.scale(1.75);
            this._sliderNode.setOffset(this._bucketWidth / 2.0 - this._sliderNode.getFullBounds().width / 2.0, this._bucketHeight / 2.0 - this._sliderNode.getFullBounds().height / 2.0);
            this._frontOfBucketLayer.addChild(this._sliderNode);
        } else {
            this._sliderNode.setVisible(bl);
        }
    }

    public NormalizedSlider getSlider() {
        return this._slider;
    }

    public void resetSliderPosition() {
        if (this._slider != null) {
            this._slider.setValue(0);
        }
    }

    public void setOffset(double d, double d2) {
        this._bucketRect.setOffset(d, d2);
        this._backOfBucketLayer.setOffset(d, d2);
        this._frontOfBucketLayer.setOffset(d, d2);
    }

    public void setOffset(Point2D point2D) {
        this.setOffset(point2D.getX(), point2D.getY());
    }

    private void positionVisibleNucleus(int n) {
        double d;
        double d2;
        AbstractAtomicNucleusNode abstractAtomicNucleusNode = this._visibleNucleusNodes[n];
        if (n < this._numVisibleNucleiInOuterLayers) {
            this._backInteriorLayer.addChild(abstractAtomicNucleusNode);
            d2 = this._nucleusWidth * 1.3 + this._nucleusWidth * (double)n * 1.1;
            d = this._ellipseVerticalSpan * 0.2;
        } else if (n < this._numVisibleNucleiInMiddleLayer + this._numVisibleNucleiInOuterLayers) {
            this._middleInteriorLayer.addChild(abstractAtomicNucleusNode);
            d2 = this._nucleusWidth * 0.8 + this._nucleusWidth * (double)(n - this._numVisibleNucleiInOuterLayers);
            d = this._ellipseVerticalSpan * 0.5;
        } else {
            this._frontInteriorLayer.addChild(abstractAtomicNucleusNode);
            d2 = this._nucleusWidth * 1.7 + this._nucleusWidth * (double)(n - this._numVisibleNucleiInOuterLayers - this._numVisibleNucleiInMiddleLayer) * 1.1;
            d = this._ellipseVerticalSpan * 0.8;
        }
        abstractAtomicNucleusNode.getNucleusRef().setPosition(d2 + this._bucketRect.getFullBounds().x, d + this._bucketRect.getFullBounds().y);
    }

    private void fillEmptyVisibleSlots() {
        block0: for (int i = 0; i < this._visibleNucleusNodes.length; ++i) {
            if (this._visibleNucleusNodes[i] != null) continue;
            for (int j = 0; j < this.getChildrenCount(); ++j) {
                PNode pNode = this.getChild(j);
                if (!(pNode instanceof AbstractAtomicNucleusNode)) continue;
                pNode.setVisible(true);
                this._visibleNucleusNodes[i] = (AbstractAtomicNucleusNode)pNode;
                this.positionVisibleNucleus(i);
                continue block0;
            }
        }
    }

    private boolean isEmpty() {
        boolean bl = true;
        if (this._visibleNucleusNodes != null) {
            for (int i = 0; i < this._visibleNucleusNodes.length; ++i) {
                if (this._visibleNucleusNodes[i] == null) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private void updateLabelText() {
        switch (this._nucleusType) {
            case POLONIUM_211: {
                this._bucketLabel.setHTML(NuclearPhysicsStrings.BUCKET_LABEL_POLONIUM);
                break;
            }
            case HEAVY_CUSTOM: {
                this._bucketLabel.setHTML(NuclearPhysicsStrings.BUCKET_LABEL_ATOMS);
                break;
            }
            case CARBON_14: {
                this._bucketLabel.setHTML(NuclearPhysicsStrings.BUCKET_LABEL_ATOMS);
                break;
            }
            default: {
                this._bucketLabel.setHTML(NuclearPhysicsStrings.BUCKET_LABEL_ATOMS);
            }
        }
        if (this._bucketLabel.getHTML().indexOf("Bucket of") != 0) {
            this._bucketLabel.setHTML(this._bucketLabel.getHTML().replaceFirst("Bucket of", "Bucket o'"));
        }
        double d = this._bucketWidth * 0.5;
        this._bucketLabel.setScale(1.0);
        this._bucketLabel.setScale(d / this._bucketLabel.getFullBoundsReference().width);
        this._bucketLabel.setOffset(this._bucketWidth / 2.0 - this._bucketLabel.getFullBounds().width / 2.0, this._bucketHeight * 0.4);
        this._bucketLabel.setVisible(this._showLabel);
    }

    private class MySliderUI
    extends BasicSliderUI {
        protected Dimension getThumbSize() {
            Dimension dimension = super.getThumbSize();
            return new Dimension(20, 40);
        }

        protected void calculateTrackRect() {
            super.calculateTrackRect();
        }
    }

    public static class NormalizedSlider
    extends JSlider {
        public NormalizedSlider() {
            super(0, 0, 1000, 0);
        }

        public double getNormalizedReading() {
            return (double)this.getValue() / 1000.0;
        }
    }

    private class ShrinkAnimationTimer
    extends Timer {
        private AbstractAtomicNucleusNode _shrinkingNode;
        private int _shrinkCount;

        public ShrinkAnimationTimer(AbstractAtomicNucleusNode abstractAtomicNucleusNode) {
            super(30, null);
            this._shrinkingNode = abstractAtomicNucleusNode;
            this._shrinkCount = 20;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ShrinkAnimationTimer.this._shrinkCount--;
                    if (ShrinkAnimationTimer.this._shrinkCount <= 0) {
                        ShrinkAnimationTimer.this.stop();
                        ShrinkAnimationTimer.this._shrinkingNode.setScale(1.0);
                        ShrinkAnimationTimer.this._shrinkingNode.setScale(0.6);
                        BucketOfNucleiNode.this.addNucleus(ShrinkAnimationTimer.this._shrinkingNode);
                        ShrinkAnimationTimer.this._shrinkingNode = null;
                        BucketOfNucleiNode.this._shrinkAnimationTimers.remove(ShrinkAnimationTimer.this);
                    } else {
                        ShrinkAnimationTimer.this._shrinkingNode.scale(0.8);
                    }
                }
            });
            this.start();
        }

        public AbstractAtomicNucleusNode getShrinkingNode() {
            return this._shrinkingNode;
        }

        public void clearShrinkingNode() {
            this.stop();
            this._shrinkingNode = null;
        }
    }
}

