/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Random;

public class Stratum {
    private LayerLine _topLine;
    private LayerLine _bottomLine;
    private GeneralPath _path = new GeneralPath();

    public Stratum(LayerLine layerLine, LayerLine layerLine2) {
        this._topLine = layerLine;
        this._bottomLine = layerLine2;
        if (layerLine2.getMinDepth() > layerLine.getMaxDepth()) {
            throw new IllegalArgumentException("No portion of bottom line can be above top line.");
        }
        this._path.append(layerLine, true);
        this._path.append(new Line2D.Double(this._topLine.getRightmostPoint(), this._bottomLine.getRightmostPoint()), true);
        this._path.append(this._bottomLine.getReverseLine(), true);
        this._path.append(new Line2D.Double(this._bottomLine.getLeftmostPoint(), this._topLine.getLeftmostPoint()), true);
    }

    public Shape getShape() {
        return this._path;
    }

    public double getBottomOfStratumY() {
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 10; ++i) {
            double d2 = (double)i * 0.1;
            if (!(this.evaluateCurve(this._bottomLine, d2).getY() < d)) continue;
            d = this.evaluateCurve(this._bottomLine, d2).getY();
        }
        return d;
    }

    public double getTopOfStratumY() {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 10; ++i) {
            double d2 = (double)i * 0.1;
            if (!(this.evaluateCurve(this._topLine, d2).getY() > d)) continue;
            d = this.evaluateCurve(this._topLine, d2).getY();
        }
        return d;
    }

    public LayerLine getBottomLine() {
        return this._bottomLine;
    }

    public double getBottomYGivenX(double d) {
        return this.getYForGivenX(d, this._bottomLine);
    }

    public double getTopYGivenX(double d) {
        return this.getYForGivenX(d, this._topLine);
    }

    private double getYForGivenX(double d, CubicCurve2D cubicCurve2D) {
        if (d < cubicCurve2D.getP1().getX() || d > cubicCurve2D.getP2().getX()) {
            System.err.println(this.getClass().getName() + ": Warning - given point outside stratum width.");
            assert (false);
            return 0.0;
        }
        double d2 = (d - cubicCurve2D.getP1().getX()) / (cubicCurve2D.getP2().getX() - cubicCurve2D.getP1().getX());
        return this.evaluateCurve(cubicCurve2D, d2).getY();
    }

    private Point2D evaluateCurve(CubicCurve2D cubicCurve2D, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("t is out of range: " + d);
        }
        Point2D point2D = this.linearInterpolation(cubicCurve2D.getP1(), cubicCurve2D.getCtrlP1(), d);
        Point2D point2D2 = this.linearInterpolation(cubicCurve2D.getCtrlP1(), cubicCurve2D.getCtrlP2(), d);
        Point2D point2D3 = this.linearInterpolation(cubicCurve2D.getCtrlP2(), cubicCurve2D.getP2(), d);
        Point2D point2D4 = this.linearInterpolation(point2D, point2D2, d);
        Point2D point2D5 = this.linearInterpolation(point2D2, point2D3, d);
        return this.linearInterpolation(point2D4, point2D5, d);
    }

    private Point2D linearInterpolation(Point2D point2D, Point2D point2D2, double d) {
        return new Point2D.Double(point2D.getX() + (point2D2.getX() - point2D.getX()) * d, point2D.getY() + (point2D2.getY() - point2D.getY()) * d);
    }

    public static class LayerLine
    extends CubicCurve2D.Double {
        private static final Random RAND = new Random(342L);
        private final Point2D _leftmostPoint;
        private final Point2D _rightmostPoint;
        private final Point2D _controlPoint1;
        private final Point2D _controlPoint2;

        public LayerLine(double d, double d2) {
            this._leftmostPoint = new Point2D.Double(-d / 2.0, -d2);
            this._rightmostPoint = new Point2D.Double(d / 2.0, -d2);
            this._controlPoint1 = new Point2D.Double(-d / 3.0, -d2 + (RAND.nextDouble() - 0.5) * 2.0 * 2.0);
            this._controlPoint2 = this._controlPoint1.getY() > -d2 ? new Point2D.Double(d / 3.0, -d2 - RAND.nextDouble() * 2.0) : new Point2D.Double(d / 3.0, -d2 + RAND.nextDouble() * 2.0);
            this.setCurve(this._leftmostPoint, this._controlPoint1, this._controlPoint2, this._rightmostPoint);
        }

        public LayerLine(double d) {
            this(200.0, d);
        }

        public double getMaxDepth() {
            return this.getBounds2D().getMinY();
        }

        public double getMinDepth() {
            return this.getBounds2D().getMaxY();
        }

        public Point2D getLeftmostPoint() {
            return this._leftmostPoint;
        }

        public Point2D getRightmostPoint() {
            return this._rightmostPoint;
        }

        public Shape getReverseLine() {
            CubicCurve2D.Double double_ = new CubicCurve2D.Double();
            double_.setCurve(this._rightmostPoint, this._controlPoint2, this._controlPoint1, this._leftmostPoint);
            return double_;
        }
    }
}

