/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.DatableItem;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AgeGuessingNode
extends PNode {
    private static final Font TEXT_FONT = new PhetFont(18);
    private static final Color BACKGROUND_COLOR = NuclearPhysicsConstants.RADIOACTIVE_DATING_GAME_CONTROL_PANEL_COLOR;
    private ArrayList<Listener> _listeners = new ArrayList();
    private JFormattedTextField _ageEntryField;

    public AgeGuessingNode(DatableItem datableItem) {
        PPath pPath = new PPath();
        pPath.setStroke(new BasicStroke(2.0f));
        pPath.setPaint(BACKGROUND_COLOR);
        this.addChild(pPath);
        PText pText = new PText(NuclearPhysicsStrings.GUESS_PROMPT);
        pText.setFont(TEXT_FONT);
        pPath.addChild(pText);
        PText pText2 = new PText(datableItem.getName());
        pText2.setFont(TEXT_FONT);
        pPath.addChild(pText2);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(BACKGROUND_COLOR);
        this._ageEntryField = new JFormattedTextField(NumberFormat.getNumberInstance());
        this._ageEntryField.setColumns(12);
        this._ageEntryField.setFont(TEXT_FONT);
        this._ageEntryField.setBorder(BorderFactory.createEtchedBorder());
        JLabel jLabel = new JLabel(NuclearPhysicsStrings.READOUT_UNITS_YRS);
        jLabel.setFont(TEXT_FONT);
        jPanel.add(this._ageEntryField);
        jPanel.add(jLabel);
        this._ageEntryField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AgeGuessingNode.this.submitGuess();
            }
        });
        PSwing pSwing = new PSwing(jPanel);
        pPath.addChild(pSwing);
        JButton jButton = new JButton(NuclearPhysicsStrings.CHECK_GUESS);
        jButton.setFont(TEXT_FONT);
        jButton.setBackground(BACKGROUND_COLOR);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AgeGuessingNode.this.submitGuess();
            }
        });
        PSwing pSwing2 = new PSwing(jButton);
        pPath.addChild(pSwing2);
        double d = Math.max(pText.getFullBoundsReference().width, Math.max(pText2.getFullBoundsReference().width, Math.max(pSwing.getFullBoundsReference().width, pSwing2.getFullBoundsReference().width)));
        double d2 = pText.getFullBoundsReference().height + pText2.getFullBoundsReference().height + pSwing.getFullBoundsReference().height + pSwing2.getFullBoundsReference().height;
        double d3 = d2 * 0.05;
        pPath.setPathToRectangle(0.0f, 0.0f, (float)(d *= 1.1), (float)(d2 *= 1.1));
        pText.setOffset(d / 2.0 - pText.getFullBoundsReference().width / 2.0, d3);
        pText2.setOffset(d / 2.0 - pText2.getFullBoundsReference().width / 2.0, pText.getFullBoundsReference().getMaxY());
        pSwing.setOffset(d / 2.0 - pSwing.getFullBoundsReference().width / 2.0, pText2.getFullBoundsReference().getMaxY());
        pSwing2.setOffset(d / 2.0 - pSwing2.getFullBoundsReference().width / 2.0, pSwing.getFullBoundsReference().getMaxY());
    }

    public boolean requestFocus() {
        return this._ageEntryField.requestFocusInWindow();
    }

    public void addListener(Listener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        if (this._listeners.remove(listener)) {
            System.err.println(this.getClass().getName() + "- Warning: attempt to remove unregistered listener.");
        }
    }

    private void submitGuess() {
        double d = this._ageEntryField.getValue() != null ? ((Number)this._ageEntryField.getValue()).doubleValue() : Double.NaN;
        this.notifyGuessSubmitted(d);
    }

    protected void notifyGuessSubmitted(double d) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).guessSubmitted(d);
        }
    }

    public static interface Listener {
        public void guessSubmitted(double var1);
    }
}

