/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.fissiononenucleus;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.common.view.AbstractAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.common.view.LabeledExplodingAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.model.AlphaParticle;
import edu.colorado.phet.nuclearphysics.model.NeutronSource;
import edu.colorado.phet.nuclearphysics.model.Uranium235CompositeNucleus;
import edu.colorado.phet.nuclearphysics.module.fissiononenucleus.FissionOneNucleusModel;
import edu.colorado.phet.nuclearphysics.view.AlphaParticleModelNode;
import edu.colorado.phet.nuclearphysics.view.FissionEnergyChart;
import edu.colorado.phet.nuclearphysics.view.NeutronSourceNode;
import edu.colorado.phet.nuclearphysics.view.NucleonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Timer;

public class FissionOneNucleusCanvas
extends PhetPCanvas {
    private final double SCALE = 0.8;
    private static final Timer BUTTON_DELAY_TIMER = new Timer(1750, null);
    private final PNode _nucleusParticlesLayerNode;
    private final PNode _nucleusLabelsLayerNode;
    private final FissionOneNucleusModel _fissionOneNucleusModel;
    private final AbstractAtomicNucleusNode _atomicNucleusNode;
    private final NeutronSourceNode _neutronSourceNode;
    private final FissionEnergyChart _fissionEnergyChart;
    private final Hashtable _particleToNodeMap;
    private final HTMLImageButtonNode _resetButtonNode;

    public FissionOneNucleusCanvas(FissionOneNucleusModel fissionOneNucleusModel) {
        this.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, new PDimension(120.0, 92.0)){

            protected AffineTransform getPreprocessedTransform() {
                return AffineTransform.getTranslateInstance(FissionOneNucleusCanvas.this.getWidth() / 2, FissionOneNucleusCanvas.this.getHeight() / 4);
            }
        });
        this.setBackground(NuclearPhysicsConstants.CANVAS_BACKGROUND);
        this._fissionOneNucleusModel = fissionOneNucleusModel;
        this._fissionOneNucleusModel.addListener(new FissionOneNucleusModel.Listener(){

            public void nucleonRemoved(Nucleon nucleon) {
                PNode pNode = (PNode)FissionOneNucleusCanvas.this._particleToNodeMap.get(nucleon);
                if (pNode != null) {
                    if (FissionOneNucleusCanvas.this._nucleusParticlesLayerNode.removeChild(pNode) == null) {
                        System.err.println("Error: Unable to locate node for given nucleon.");
                    }
                    FissionOneNucleusCanvas.this._particleToNodeMap.remove(nucleon);
                } else {
                    System.err.println("Error: Unable to locate particle in particle-to-node map.");
                }
            }
        });
        this._fissionOneNucleusModel.getAtomicNucleus().addListener(new AtomicNucleus.Adapter(){

            public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
                if (arrayList != null) {
                    BUTTON_DELAY_TIMER.restart();
                } else {
                    FissionOneNucleusCanvas.this._resetButtonNode.setVisible(false);
                }
            }
        });
        this._nucleusParticlesLayerNode = new PNode();
        this.addWorldChild(this._nucleusParticlesLayerNode);
        this._nucleusLabelsLayerNode = new PNode();
        this.addWorldChild(this._nucleusLabelsLayerNode);
        Uranium235CompositeNucleus uranium235CompositeNucleus = this._fissionOneNucleusModel.getAtomicNucleus();
        ArrayList arrayList = uranium235CompositeNucleus.getConstituents();
        this._particleToNodeMap = new Hashtable(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            PNode pNode;
            Object e = arrayList.get(i);
            if (e instanceof AlphaParticle) {
                pNode = new AlphaParticleModelNode((AlphaParticle)e);
                this._nucleusParticlesLayerNode.addChild(pNode);
                this._particleToNodeMap.put(e, pNode);
                continue;
            }
            if (e instanceof Nucleon) {
                pNode = new NucleonNode((Nucleon)e);
                this._nucleusParticlesLayerNode.addChild(pNode);
                this._particleToNodeMap.put(e, pNode);
                continue;
            }
            assert (false);
        }
        this._atomicNucleusNode = new LabeledExplodingAtomicNucleusNode(fissionOneNucleusModel.getAtomicNucleus());
        this._nucleusLabelsLayerNode.addChild(this._atomicNucleusNode);
        this._neutronSourceNode = new NeutronSourceNode(fissionOneNucleusModel.getNeutronSource(), 26.0);
        this._neutronSourceNode.setRotationEnabled(false);
        this.addWorldChild(this._neutronSourceNode);
        fissionOneNucleusModel.getNeutronSource().addListener(new NeutronSource.Adapter(){

            public void neutronGenerated(Nucleon nucleon) {
                NucleonNode nucleonNode = new NucleonNode(nucleon);
                FissionOneNucleusCanvas.this._nucleusParticlesLayerNode.addChild(nucleonNode);
                FissionOneNucleusCanvas.this._particleToNodeMap.put(nucleon, nucleonNode);
            }
        });
        this._resetButtonNode = new HTMLImageButtonNode(NuclearPhysicsStrings.RESET_NUCLEUS, new PhetFont(1, 16), NuclearPhysicsConstants.CANVAS_RESET_BUTTON_COLOR);
        double d = this._neutronSourceNode.getFullBoundsReference().width;
        this._resetButtonNode.setScale(d / this._resetButtonNode.getFullBoundsReference().width);
        this._resetButtonNode.setOffset(this._neutronSourceNode.getFullBoundsReference().x, this._neutronSourceNode.getFullBoundsReference().y - this._resetButtonNode.getFullBoundsReference().height * 2.0);
        this.addWorldChild(this._resetButtonNode);
        this._resetButtonNode.setVisible(false);
        this._resetButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FissionOneNucleusCanvas.this._fissionOneNucleusModel.getClock().resetSimulationTime();
            }
        });
        BUTTON_DELAY_TIMER.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FissionOneNucleusCanvas.this._resetButtonNode.setVisible(true);
                BUTTON_DELAY_TIMER.stop();
            }
        });
        this._fissionEnergyChart = new FissionEnergyChart(this._fissionOneNucleusModel, this);
        this.addScreenChild(this._fissionEnergyChart);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                FissionOneNucleusCanvas.this._fissionEnergyChart.componentResized(FissionOneNucleusCanvas.this.getWidth(), FissionOneNucleusCanvas.this.getHeight());
            }
        });
    }
}

