/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.decayrates;

import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.MultiNucleusDecayModel;
import edu.colorado.phet.nuclearphysics.model.Carbon14Nucleus;
import edu.colorado.phet.nuclearphysics.model.HeavyAdjustableHalfLifeNucleus;
import edu.colorado.phet.nuclearphysics.model.Uranium238Nucleus;
import edu.colorado.phet.nuclearphysics.module.betadecay.LabelVisibilityModel;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class DecayRatesModel
extends MultiNucleusDecayModel {
    private static final NucleusType DEFAULT_NUCLEUS_TYPE = NucleusType.CARBON_14;
    private static final Rectangle2D HOLDING_AREA_RECT = new Rectangle2D.Double(220.0, 35.0, 190.0, 120.0);
    private static final Random _rand = new Random();
    private double _worldSizeX = 800.0;
    private double _worldSizeY = 320.0;

    public DecayRatesModel(NuclearPhysicsClock nuclearPhysicsClock) {
        super(nuclearPhysicsClock, 1000, DEFAULT_NUCLEUS_TYPE, false, new LabelVisibilityModel());
    }

    public Rectangle2D getHoldingAreaRect() {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double_.setRect(HOLDING_AREA_RECT);
        return double_;
    }

    public int getNumNucleiInHoldingArea() {
        int n = 0;
        for (AtomicNucleus atomicNucleus : this._atomicNuclei) {
            if (!this.isNucleusInHoldingArea(atomicNucleus)) continue;
            ++n;
        }
        return n;
    }

    public void moveNucleusToHoldingArea(AtomicNucleus atomicNucleus) {
        if (!this._atomicNuclei.contains(atomicNucleus)) {
            throw new IllegalArgumentException("Specified nucleus is not part of model.");
        }
        atomicNucleus.setPosition(HOLDING_AREA_RECT.getCenterX(), HOLDING_AREA_RECT.getCenterY());
    }

    public AtomicNucleus getAnyNonHeldNucleus() {
        AtomicNucleus atomicNucleus = null;
        for (AtomicNucleus atomicNucleus2 : this._atomicNuclei) {
            if (this.isNucleusInHoldingArea(atomicNucleus2)) continue;
            atomicNucleus = atomicNucleus2;
            break;
        }
        return atomicNucleus;
    }

    public boolean isNucleusInHoldingArea(AtomicNucleus atomicNucleus) {
        return HOLDING_AREA_RECT.contains(atomicNucleus.getPositionReference());
    }

    protected void addMaxNuclei() {
        for (int i = 0; i < this._maxNuclei; ++i) {
            AtomicNucleus atomicNucleus = this._currentNucleusType == NucleusType.CARBON_14 ? new Carbon14Nucleus(this._clock, new Point2D.Double(0.0, 0.0), true) : (this._currentNucleusType == NucleusType.URANIUM_238 ? new Uranium238Nucleus(this._clock) : new HeavyAdjustableHalfLifeNucleus(this._clock));
            this._atomicNuclei.add(atomicNucleus);
            this._jitterOffsets[i] = new Point2D.Double();
            atomicNucleus.setPosition(HOLDING_AREA_RECT.getCenterX(), HOLDING_AREA_RECT.getCenterY());
            this.notifyModelElementAdded(atomicNucleus);
            atomicNucleus.addListener(this._nucleusListener);
        }
    }

    public Point2D findOpenNucleusLocation() {
        double d;
        Point2D.Double double_ = null;
        boolean bl = false;
        double d2 = 10.0;
        if (this._atomicNuclei.size() > 0) {
            d2 = Math.min(((AtomicNucleus)this._atomicNuclei.get(0)).getDiameter() * 1.5, 10.0);
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 25; ++j) {
                d = this._worldSizeX * (_rand.nextDouble() - 0.5);
                double d3 = this._worldSizeY * (_rand.nextDouble() - 0.5);
                double_ = new Point2D.Double(d, d3);
                bl = true;
                for (int k = 0; k < this._atomicNuclei.size() && bl; ++k) {
                    AtomicNucleus atomicNucleus = (AtomicNucleus)this._atomicNuclei.get(k);
                    if (!(double_.distance(atomicNucleus.getPositionReference()) < d2) && !HOLDING_AREA_RECT.contains(double_)) continue;
                    bl = false;
                }
                if (bl) break;
            }
            if (bl) break;
            d2 /= 2.0;
        }
        if (!bl) {
            double d4;
            System.out.println("Warning: Using arbitrary location because no open location found.");
            while (HOLDING_AREA_RECT.contains(double_ = new Point2D.Double(d4 = this._worldSizeX * (_rand.nextDouble() - 0.5), d = this._worldSizeY * (_rand.nextDouble() - 0.5)))) {
            }
        }
        return double_;
    }

    public double convertSimTimeToAdjustedTime(double d) {
        double d2 = 1.0;
        if (this._atomicNuclei.size() > 1) {
            d2 = ((AtomicNucleus)this._atomicNuclei.get(0)).getDecayTimeScalingFactor();
        } else {
            System.err.println(this.getClass().getName() + "Warning: No nuclei available to provide conversion factor.");
            assert (false);
        }
        return d / d2;
    }
}

