/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.decayrates;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.NuclearDecayControl;
import edu.colorado.phet.nuclearphysics.common.view.AbstractAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.common.view.UnlabeledSphericalAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.colorado.phet.nuclearphysics.model.NuclearDecayListenerAdapter;
import edu.colorado.phet.nuclearphysics.module.decayrates.DecayRatesModel;
import edu.colorado.phet.nuclearphysics.view.AutoPressButtonNode;
import edu.colorado.phet.nuclearphysics.view.BucketOfNucleiNode;
import edu.colorado.phet.nuclearphysics.view.NuclearDecayProportionChart;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DecayRatesCanvas
extends PhetPCanvas {
    private final double CANVAS_WIDTH = 900.0;
    private final double CANVAS_HEIGHT = 675.0;
    private final double WIDTH_TRANSLATION_FACTOR = 0.5;
    private final double HEIGHT_TRANSLATION_FACTOR = 0.29;
    private final double PROPORTION_CHART_FRACTION = 0.45;
    private static final Color BUCKET_AND_BUTTON_COLOR = new Color(90, 180, 225);
    private DecayRatesModel _model;
    private HashMap<AtomicNucleus, AbstractAtomicNucleusNode> _mapNucleiToNodes = new HashMap();
    private NuclearDecayProportionChart _proportionsChart;
    private int _proportionsChartUpdateCounter = 0;
    private PNode _particleLayer;
    private PNode _chartLayer;
    private BucketOfNucleiNode _bucketNode;
    private AutoPressButtonNode _resetButtonNode;
    private PPath _holdingAreaRect;

    public DecayRatesCanvas(DecayRatesModel decayRatesModel) {
        this._model = decayRatesModel;
        this._model.getClock().addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                if (DecayRatesCanvas.this._proportionsChartUpdateCounter++ % 1 == 0 && DecayRatesCanvas.this._model.getNumActiveNuclei() > 0) {
                    DecayRatesCanvas.this.addNewDataPointToChart();
                }
            }
        });
        this.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, new PDimension(900.0, 675.0)){

            protected AffineTransform getPreprocessedTransform() {
                return AffineTransform.getTranslateInstance((double)DecayRatesCanvas.this.getWidth() * 0.5, (double)DecayRatesCanvas.this.getHeight() * 0.29);
            }
        });
        this.setBackground(NuclearPhysicsConstants.CANVAS_BACKGROUND);
        this._holdingAreaRect = new PhetPPath((Shape)new Rectangle2D.Double(0.0, 0.0, this._model.getHoldingAreaRect().getWidth(), this._model.getHoldingAreaRect().getHeight()), (Paint)Color.CYAN);
        this._holdingAreaRect.setOffset(this._model.getHoldingAreaRect().getX(), this._model.getHoldingAreaRect().getY());
        this._particleLayer = new PNode();
        this.addWorldChild(this._particleLayer);
        this._chartLayer = new PNode();
        this.addWorldChild(this._chartLayer);
        Rectangle2D rectangle2D = this._model.getHoldingAreaRect();
        rectangle2D.setRect(rectangle2D.getX() + 0.1 * rectangle2D.getWidth(), rectangle2D.getY() + 0.1 * rectangle2D.getHeight(), rectangle2D.getWidth() * 0.8, rectangle2D.getHeight() * 0.9);
        this._bucketNode = new BucketOfNucleiNode(rectangle2D.getWidth(), rectangle2D.getHeight(), 0.2617993877991494, BUCKET_AND_BUTTON_COLOR);
        this._particleLayer.addChild(this._bucketNode);
        this._bucketNode.setShowLabel(false);
        this._bucketNode.setShowRadiationSymbol(false);
        this._bucketNode.setSliderEnabled(true);
        this._bucketNode.setOffset(rectangle2D.getX(), rectangle2D.getY());
        this._bucketNode.getSlider().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DecayRatesCanvas.this.setProportionOfNucleiOutsideHoldingArea(DecayRatesCanvas.this._bucketNode.getSlider().getNormalizedReading());
            }
        });
        this._bucketNode.getSlider().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DecayRatesCanvas.this._model.getClock().setPaused(true);
                DecayRatesCanvas.this._model.getClock().resetSimulationTime();
                DecayRatesCanvas.this._model.resetActiveAndDecayedNuclei();
                DecayRatesCanvas.this._proportionsChart.clear();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DecayRatesCanvas.this._model.getClock().setPaused(false);
            }
        });
        this._resetButtonNode = new AutoPressButtonNode(NuclearPhysicsStrings.RESET_ALL_NUCLEI, 22, BUCKET_AND_BUTTON_COLOR);
        this._resetButtonNode.setOffset(this._bucketNode.getFullBoundsReference().getCenterX() - this._resetButtonNode.getFullBoundsReference().width / 2.0, -70.0);
        this._chartLayer.addChild(this._resetButtonNode);
        this._resetButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DecayRatesCanvas.this._model.getClock().resetSimulationTime();
                DecayRatesCanvas.this._model.resetActiveAndDecayedNuclei();
                DecayRatesCanvas.this._proportionsChart.clear();
            }
        });
        this._proportionsChart = new NuclearDecayProportionChart(true, false, true, true);
        this._proportionsChart.setDisplayInfoForNucleusType(this._model.getNucleusType());
        this._proportionsChart.setSquareModeEnabled(true);
        this._chartLayer.addChild(this._proportionsChart);
        this._model.addListener(new NuclearDecayListenerAdapter(){

            public void modelElementAdded(Object object) {
                DecayRatesCanvas.this.handleModelElementAdded(object);
            }

            public void modelElementRemoved(Object object) {
                DecayRatesCanvas.this.handleModelElementRemoved(object);
            }

            public void nucleusTypeChanged() {
                DecayRatesCanvas.this._proportionsChart.clear();
                double d = HalfLifeInfo.getHalfLifeForNucleusType(DecayRatesCanvas.this._model.getNucleusType());
                DecayRatesCanvas.this._proportionsChart.setTimeParameters(d * 3.2, d);
                DecayRatesCanvas.this._proportionsChart.setDisplayInfoForNucleusType(DecayRatesCanvas.this._model.getNucleusType());
                DecayRatesCanvas.this._bucketNode.resetSliderPosition();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DecayRatesCanvas.this.update();
            }
        });
        this._model.getClock().addClockListener(new ClockAdapter(){

            public void simulationTimeReset(ClockEvent clockEvent) {
                DecayRatesCanvas.this._proportionsChart.clear();
            }
        });
    }

    private void setProportionOfNucleiOutsideHoldingArea(double d) {
        int n;
        int n2 = this._model.getTotalNumNuclei();
        int n3 = n2 - (n = this._model.getNumNucleiInHoldingArea());
        double d2 = (double)n3 / (double)n2;
        if (d2 > d) {
            int n4 = n3 - (int)Math.round(d * (double)n2);
            this.moveNucleiToBucket(n4);
        } else if (d2 < d) {
            int n5 = (int)Math.round(d * (double)n2) - n3;
            this.moveNucleiFromBucket(n5);
        }
    }

    public void update() {
        super.update();
        this._proportionsChart.componentResized(new Rectangle2D.Double(0.0, 0.0, this.getWorldSize().getWidth() * 1.0 - 15.0, this.getWorldSize().getHeight() * 0.45));
        PBounds pBounds = this._proportionsChart.getFullBoundsReference();
        this._proportionsChart.setOffset(-pBounds.width / 2.0 + 3.0, this.getWorldSize().getHeight() * 0.71 - this._proportionsChart.getFullBoundsReference().height);
    }

    private int moveNucleiFromBucket(int n) {
        AbstractAtomicNucleusNode abstractAtomicNucleusNode;
        int n2;
        for (n2 = 0; n2 < n && (abstractAtomicNucleusNode = this._bucketNode.extractAnyNucleusFromBucket()) != null; ++n2) {
            this._particleLayer.addChild(abstractAtomicNucleusNode);
            abstractAtomicNucleusNode.getNucleusRef().setPosition(this._model.findOpenNucleusLocation());
            AtomicNucleus atomicNucleus = abstractAtomicNucleusNode.getNucleusRef();
            if (!(atomicNucleus instanceof NuclearDecayControl)) continue;
            atomicNucleus.activateDecay();
        }
        return n2;
    }

    private int moveNucleiToBucket(int n) {
        AtomicNucleus atomicNucleus;
        int n2;
        for (n2 = 0; n2 < n && (atomicNucleus = this._model.getAnyNonHeldNucleus()) != null; ++n2) {
            atomicNucleus.reset();
            this._model.moveNucleusToHoldingArea(atomicNucleus);
            AbstractAtomicNucleusNode abstractAtomicNucleusNode = this._mapNucleiToNodes.get(atomicNucleus);
            this._bucketNode.addNucleus(abstractAtomicNucleusNode);
        }
        return n2;
    }

    private void handleModelElementAdded(Object object) {
        if (object instanceof AtomicNucleus) {
            AtomicNucleus atomicNucleus = (AtomicNucleus)object;
            UnlabeledSphericalAtomicNucleusNode unlabeledSphericalAtomicNucleusNode = new UnlabeledSphericalAtomicNucleusNode(atomicNucleus);
            this._mapNucleiToNodes.put(atomicNucleus, unlabeledSphericalAtomicNucleusNode);
            if (this._model.isNucleusInHoldingArea(atomicNucleus)) {
                this._bucketNode.addNucleus(unlabeledSphericalAtomicNucleusNode);
            } else {
                this._particleLayer.addChild(unlabeledSphericalAtomicNucleusNode);
            }
        } else {
            System.err.println("WARNING: Unrecognized model element added, unable to create node for canvas.");
        }
    }

    private void handleModelElementRemoved(Object object) {
        if (object instanceof AtomicNucleus) {
            AbstractAtomicNucleusNode abstractAtomicNucleusNode = this._mapNucleiToNodes.get(object);
            if (abstractAtomicNucleusNode == null) {
                System.err.println(this.getClass().getName() + ": Error - Could not find node for removed model element.");
            } else {
                if (this._bucketNode.isNodeInBucket(abstractAtomicNucleusNode)) {
                    this._bucketNode.removeNucleus(abstractAtomicNucleusNode);
                } else {
                    PNode pNode = this._particleLayer.removeChild(abstractAtomicNucleusNode);
                    if (pNode == null) {
                        System.err.println(this.getClass().getName() + ": Error - Could not remove nucleus from canvas.");
                    }
                }
                abstractAtomicNucleusNode.cleanup();
            }
            this._mapNucleiToNodes.remove(object);
        }
    }

    private void addNewDataPointToChart() {
        this._proportionsChart.addDataPoint(this._model.convertSimTimeToAdjustedTime(this._model.getClock().getSimulationTime()), this._model.getNumActiveNuclei(), this._model.getNumDecayedNuclei());
    }
}

