/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.chainreaction;

import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.control.NuclearPhysicsClockControlPanel;
import edu.colorado.phet.nuclearphysics.module.chainreaction.ChainReactionCanvas;
import edu.colorado.phet.nuclearphysics.module.chainreaction.ChainReactionControlPanel;
import edu.colorado.phet.nuclearphysics.module.chainreaction.ChainReactionModel;
import java.awt.Frame;

public class ChainReactionModule
extends PiccoloModule {
    private ChainReactionModel _model;
    private ChainReactionCanvas _canvas;
    private ChainReactionControlPanel _controlPanel;
    private NuclearPhysicsClockControlPanel _clockControlPanel;

    public ChainReactionModule(Frame frame) {
        super(NuclearPhysicsStrings.TITLE_CHAIN_REACTION_MODULE, new NuclearPhysicsClock(25, 5.0));
        NuclearPhysicsClock nuclearPhysicsClock = (NuclearPhysicsClock)this.getClock();
        this._model = new ChainReactionModel(nuclearPhysicsClock);
        this._canvas = new ChainReactionCanvas(this._model);
        this.setSimulationPanel(this._canvas);
        this._controlPanel = new ChainReactionControlPanel(this, frame);
        this.setControlPanel(this._controlPanel);
        this._clockControlPanel = new NuclearPhysicsClockControlPanel(this.getClock());
        this.setClockControlPanel(this._clockControlPanel);
        if (this.hasHelp()) {
            // empty if block
        }
        this.reset();
    }

    public void reset() {
        this._model.getClock().resetSimulationTime();
        this.setClockRunningWhenActive(true);
    }

    public ChainReactionModel getChainReactionModel() {
        return this._model;
    }
}

