/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.chainreaction;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.common.view.AtomicNucleusImageNode;
import edu.colorado.phet.nuclearphysics.common.view.AtomicNucleusImageType;
import edu.colorado.phet.nuclearphysics.model.Uranium235CompositeNucleus;
import edu.colorado.phet.nuclearphysics.module.betadecay.LabelVisibilityModel;
import edu.colorado.phet.nuclearphysics.module.chainreaction.ChainReactionModel;
import edu.colorado.phet.nuclearphysics.view.AtomicBombGraphicNode;
import edu.colorado.phet.nuclearphysics.view.ContainmentVesselNode;
import edu.colorado.phet.nuclearphysics.view.NeutronSourceNode;
import edu.colorado.phet.nuclearphysics.view.NucleonNode;
import edu.colorado.phet.nuclearphysics.view.NucleusImageFactory;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Timer;

public class ChainReactionCanvas
extends PhetPCanvas {
    private final double CANVAS_WIDTH = 200.0;
    private final double CANVAS_HEIGHT = 174.0;
    private final double WIDTH_TRANSLATION_FACTOR = 2.0;
    private final double HEIGHT_TRANSLATION_FACTOR = 2.0;
    private final int REACTION_STATE_NO_REACTION_PRODUCTS_PRESENT = 0;
    private final int REACTION_STATE_REACTION_OR_ADJUSTMENT_IN_PROGRESS = 1;
    private final int REACTION_STATE_REACTION_COMPLETE = 2;
    private static final Timer BUTTON_DELAY_TIMER = new Timer(1500, null);
    private ChainReactionModel _chainReactionModel;
    private HashMap _modelElementToNodeMap = new HashMap();
    private PNode _nucleusLayer;
    private NeutronSourceNode _neutronSourceNode;
    AtomicBombGraphicNode _atomicBombGraphicNode;
    private HTMLImageButtonNode _resetNucleiButtonNode;
    private int _reactionState = 0;

    public ChainReactionCanvas(ChainReactionModel chainReactionModel) {
        this._chainReactionModel = chainReactionModel;
        this._chainReactionModel.addListener(new ChainReactionModel.Adapter(){

            public void modelElementAdded(Object object) {
                ChainReactionCanvas.this.handleModelElementAdded(object);
            }

            public void modelElementRemoved(Object object) {
                ChainReactionCanvas.this.handleModelElementRemoved(object);
            }

            public void reactiveNucleiNumberChanged() {
                ChainReactionCanvas.this.handleReactiveNucleiNumberChanged();
            }

            public void resetOccurred() {
                if (BUTTON_DELAY_TIMER.isRunning()) {
                    BUTTON_DELAY_TIMER.stop();
                }
                ChainReactionCanvas.this._resetNucleiButtonNode.setVisible(false);
                ChainReactionCanvas.this._reactionState = 0;
            }
        });
        this.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, new PDimension(200.0, 174.0)){

            protected AffineTransform getPreprocessedTransform() {
                return AffineTransform.getTranslateInstance((double)ChainReactionCanvas.this.getWidth() / 2.0, (double)ChainReactionCanvas.this.getHeight() / 2.0);
            }
        });
        this.setBackground(NuclearPhysicsConstants.CANVAS_BACKGROUND);
        NucleusImageFactory.getInstance().preGenerateNucleusImages(92, 143, 20.0);
        NucleusImageFactory.getInstance().preGenerateNucleusImages(92, 144, 20.0);
        NucleusImageFactory.getInstance().preGenerateNucleusImages(92, 146, 20.0);
        NucleusImageFactory.getInstance().preGenerateNucleusImages(92, 147, 20.0);
        NucleusImageFactory.getInstance().preGenerateNucleusImages(36, 56, 20.0);
        NucleusImageFactory.getInstance().preGenerateNucleusImages(56, 85, 20.0);
        this._nucleusLayer = new PNode();
        this.addWorldChild(this._nucleusLayer);
        this.addWorldChild(new ContainmentVesselNode(this._chainReactionModel.getContainmentVessel(), this, this._chainReactionModel.getClock()));
        this._resetNucleiButtonNode = new HTMLImageButtonNode(NuclearPhysicsStrings.RESET_NUCLEI, new PhetFont(1, 16), NuclearPhysicsConstants.CANVAS_RESET_BUTTON_COLOR);
        this._resetNucleiButtonNode.setScale(0.4);
        this._resetNucleiButtonNode.setOffset(-100.0, -70.0);
        this.addWorldChild(this._resetNucleiButtonNode);
        this._resetNucleiButtonNode.setVisible(false);
        this._resetNucleiButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChainReactionCanvas.this._chainReactionModel.resetNuclei();
            }
        });
        BUTTON_DELAY_TIMER.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ChainReactionCanvas.this._reactionState == 1) {
                    ChainReactionCanvas.this._resetNucleiButtonNode.setVisible(true);
                    BUTTON_DELAY_TIMER.stop();
                    ChainReactionCanvas.this._reactionState = 2;
                } else {
                    System.err.println("Error: Unexpected timer expiration.");
                    BUTTON_DELAY_TIMER.stop();
                }
            }
        });
        this._neutronSourceNode = new NeutronSourceNode(this._chainReactionModel.getNeutronSource(), 50.0);
        this.addWorldChild(this._neutronSourceNode);
        this._atomicBombGraphicNode = new AtomicBombGraphicNode(this._chainReactionModel.getContainmentVessel(), this._chainReactionModel.getClock());
        this.updateAtomicBombGraphicLocation();
        this.addScreenChild(this._atomicBombGraphicNode);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ChainReactionCanvas.this.updateAtomicBombGraphicLocation();
            }
        });
        ArrayList arrayList = this._chainReactionModel.getNuclei();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(arrayList.get(i) instanceof Uranium235CompositeNucleus)) continue;
            this.handleModelElementAdded(arrayList.get(i));
        }
    }

    private void handleModelElementAdded(Object object) {
        if (object instanceof AtomicNucleus) {
            AtomicNucleusImageNode atomicNucleusImageNode = new AtomicNucleusImageNode((AtomicNucleus)object, AtomicNucleusImageType.NUCLEONS_VISIBLE, new LabelVisibilityModel());
            this._nucleusLayer.addChild(atomicNucleusImageNode);
            this._modelElementToNodeMap.put(object, atomicNucleusImageNode);
        } else if (object instanceof Nucleon && ((Nucleon)object).getNucleonType() == Nucleon.NucleonType.NEUTRON) {
            NucleonNode nucleonNode = new NucleonNode((Nucleon)object);
            this._nucleusLayer.addChild(nucleonNode);
            this._modelElementToNodeMap.put(object, nucleonNode);
        } else {
            System.err.println("Error: Unable to find appropriate node for model element.");
        }
    }

    private void handleModelElementRemoved(Object object) {
        Object v = this._modelElementToNodeMap.get(object);
        if (v != null || v instanceof PNode) {
            if (object instanceof AtomicNucleus) {
                this._nucleusLayer.removeChild((PNode)v);
                this._modelElementToNodeMap.remove(object);
            } else {
                this._nucleusLayer.removeChild((PNode)v);
                this._modelElementToNodeMap.remove(object);
            }
        } else {
            System.err.println("Error: Problem encountered removing node from canvas.");
        }
    }

    private void updateAtomicBombGraphicLocation() {
        this._atomicBombGraphicNode.setContainerSize(this.getWidth(), this.getHeight());
    }

    private void handleReactiveNucleiNumberChanged() {
        switch (this._reactionState) {
            case 0: {
                if (!this._chainReactionModel.getChangedNucleiExist()) break;
                this._reactionState = 1;
                BUTTON_DELAY_TIMER.restart();
                break;
            }
            case 1: {
                if (!this._chainReactionModel.getChangedNucleiExist()) {
                    BUTTON_DELAY_TIMER.stop();
                    this._resetNucleiButtonNode.setVisible(false);
                    this._reactionState = 0;
                    break;
                }
                BUTTON_DELAY_TIMER.restart();
                break;
            }
            case 2: {
                if (this._chainReactionModel.getChangedNucleiExist()) break;
                BUTTON_DELAY_TIMER.stop();
                this._resetNucleiButtonNode.setVisible(false);
                this._reactionState = 0;
            }
        }
    }
}

