/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.alphadecay.singlenucleus;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.NuclearDecayModelListener;
import edu.colorado.phet.nuclearphysics.common.model.NucleusTypeControl;
import edu.colorado.phet.nuclearphysics.model.AdjustableHalfLifeCompositeNucleus;
import edu.colorado.phet.nuclearphysics.model.AlphaDecayCompositeNucleus;
import edu.colorado.phet.nuclearphysics.model.AlphaParticle;
import edu.colorado.phet.nuclearphysics.model.Polonium211CompositeNucleus;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class SingleNucleusAlphaDecayModel
implements NucleusTypeControl {
    public NucleusType DEFAULT_NUCLEUS_TYPE = NucleusType.POLONIUM_211;
    private AlphaDecayCompositeNucleus _atomicNucleus;
    private AlphaParticle _tunneledAlpha;
    private NuclearPhysicsClock _clock;
    private ArrayList _listeners = new ArrayList();
    private NucleusType _nucleusType;
    private AtomicNucleus.Adapter _atomicNucleusAdapter;

    public SingleNucleusAlphaDecayModel(NuclearPhysicsClock nuclearPhysicsClock) {
        this._clock = nuclearPhysicsClock;
        this._nucleusType = this.DEFAULT_NUCLEUS_TYPE;
        nuclearPhysicsClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                SingleNucleusAlphaDecayModel.this.handleClockTicked(clockEvent);
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
                SingleNucleusAlphaDecayModel.this.removeCurrentNucleus();
                NucleusType nucleusType = SingleNucleusAlphaDecayModel.this._nucleusType;
                SingleNucleusAlphaDecayModel.this._nucleusType = SingleNucleusAlphaDecayModel.this.DEFAULT_NUCLEUS_TYPE;
                SingleNucleusAlphaDecayModel.this.addNewNucleus();
                if (nucleusType != SingleNucleusAlphaDecayModel.this.DEFAULT_NUCLEUS_TYPE) {
                    SingleNucleusAlphaDecayModel.this.notifyNucleusTypeChanged();
                }
            }
        });
        this._atomicNucleusAdapter = new AtomicNucleus.Adapter(){

            public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Object e = arrayList.get(i);
                        if (e instanceof AlphaParticle) {
                            SingleNucleusAlphaDecayModel.this._tunneledAlpha = (AlphaParticle)e;
                            continue;
                        }
                        System.err.println("Error: Unexpected byproduct of decay event.");
                        assert (false);
                    }
                }
            }
        };
    }

    public AlphaDecayCompositeNucleus getAtomNucleus() {
        return this._atomicNucleus;
    }

    public ConstantDtClock getClock() {
        return this._clock;
    }

    public void setNucleusType(NucleusType nucleusType) {
        if (this._nucleusType == nucleusType) {
            return;
        }
        this.removeCurrentNucleus();
        this._nucleusType = nucleusType;
        this.addNewNucleus();
        this.notifyNucleusTypeChanged();
    }

    public NucleusType getNucleusType() {
        return this._nucleusType;
    }

    public void resetNucleus() {
        this._atomicNucleus.reset(this._tunneledAlpha);
        if (this._tunneledAlpha != null) {
            this.notifyModelElementRemoved(this._tunneledAlpha);
        }
        this._tunneledAlpha = null;
    }

    public void setPaused(boolean bl) {
        this._atomicNucleus.setPaused(bl);
    }

    public void addListener(NuclearDecayModelListener nuclearDecayModelListener) {
        assert (!this._listeners.contains(nuclearDecayModelListener));
        if (!this._listeners.contains(nuclearDecayModelListener)) {
            this._listeners.add(nuclearDecayModelListener);
        }
    }

    public double getHalfLife() {
        if (this._atomicNucleus != null) {
            return this._atomicNucleus.getHalfLife();
        }
        return 0.0;
    }

    public void setHalfLife(double d) {
        if (this._nucleusType != NucleusType.HEAVY_CUSTOM) {
            System.err.println(this.getClass().getName() + "- Warning: Can only set nucleus type for custom nucleus, ignoring request.");
            return;
        }
        AdjustableHalfLifeCompositeNucleus adjustableHalfLifeCompositeNucleus = (AdjustableHalfLifeCompositeNucleus)this._atomicNucleus;
        adjustableHalfLifeCompositeNucleus.setHalfLife(d);
        this.resetNucleus();
        this.notifyHalfLifeChanged();
    }

    private void handleClockTicked(ClockEvent clockEvent) {
        if (this._tunneledAlpha != null) {
            this._tunneledAlpha.moveOut();
        }
    }

    private void removeCurrentNucleus() {
        if (this._atomicNucleus == null) {
            return;
        }
        this._atomicNucleus.removeListener(this._atomicNucleusAdapter);
        this._tunneledAlpha = null;
        this._atomicNucleus.removedFromModel();
        AlphaDecayCompositeNucleus alphaDecayCompositeNucleus = this._atomicNucleus;
        this._atomicNucleus = null;
        this.notifyModelElementRemoved(alphaDecayCompositeNucleus);
    }

    private void addNewNucleus() {
        if (this._atomicNucleus != null) {
            System.err.println("Warning: Removing existing nucleus before adding new one.");
            this.removeCurrentNucleus();
        }
        switch (this._nucleusType) {
            case POLONIUM_211: {
                this._atomicNucleus = new Polonium211CompositeNucleus(this._clock, new Point2D.Double(0.0, 0.0));
                break;
            }
            case HEAVY_CUSTOM: {
                this._atomicNucleus = new AdjustableHalfLifeCompositeNucleus(this._clock, new Point2D.Double(0.0, 0.0));
            }
        }
        this._atomicNucleus.activateDecay();
        this._atomicNucleus.addListener(this._atomicNucleusAdapter);
        this.notifyModelElementAdded(this._atomicNucleus);
    }

    private void notifyModelElementRemoved(Object object) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((NuclearDecayModelListener)this._listeners.get(i)).modelElementRemoved(object);
        }
    }

    private void notifyModelElementAdded(Object object) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((NuclearDecayModelListener)this._listeners.get(i)).modelElementAdded(object);
        }
    }

    private void notifyNucleusTypeChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((NuclearDecayModelListener)this._listeners.get(i)).nucleusTypeChanged();
        }
    }

    private void notifyHalfLifeChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((NuclearDecayModelListener)this._listeners.get(i)).halfLifeChanged();
        }
    }
}

