/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.alphadecay.multinucleus;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.NuclearDecayControl;
import edu.colorado.phet.nuclearphysics.common.view.AbstractAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.common.view.AtomicNucleusImageType;
import edu.colorado.phet.nuclearphysics.common.view.GrabbableNucleusImageNode;
import edu.colorado.phet.nuclearphysics.model.AlphaParticle;
import edu.colorado.phet.nuclearphysics.model.NuclearDecayListenerAdapter;
import edu.colorado.phet.nuclearphysics.module.alphadecay.multinucleus.MultiNucleusAlphaDecayModel;
import edu.colorado.phet.nuclearphysics.module.betadecay.LabelVisibilityModel;
import edu.colorado.phet.nuclearphysics.module.halflife.AutopressResetButton;
import edu.colorado.phet.nuclearphysics.view.AlphaParticleModelNode;
import edu.colorado.phet.nuclearphysics.view.AutoPressButtonNode;
import edu.colorado.phet.nuclearphysics.view.BucketOfNucleiNode;
import edu.colorado.phet.nuclearphysics.view.MultiNucleusDecayLinearTimeChart;
import edu.colorado.phet.nuclearphysics.view.NucleusImageFactory;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class MultiNucleusAlphaDecayCanvas
extends PhetPCanvas
implements AutopressResetButton {
    private final double CANVAS_WIDTH = 200.0;
    private final double CANVAS_HEIGHT = 150.0;
    private final double WIDTH_TRANSLATION_FACTOR = 0.5;
    private final double HEIGHT_TRANSLATION_FACTOR = 0.45;
    private final double TIME_CHART_VERTICAL_FRACTION = 0.23;
    private final double TIME_CHART_HORIZONTAL_FRACTION = 0.95;
    private static final Color CANVAS_BUTTON_COLOR = new Color(255, 100, 0);
    private MultiNucleusDecayLinearTimeChart _decayTimeChart;
    private AutoPressButtonNode _resetButtonNode;
    private HTMLImageButtonNode _addTenButtonNode;
    private MultiNucleusAlphaDecayModel _model;
    private Rectangle2D _bucketRect;
    private BucketOfNucleiNode _bucketNode;
    private HashMap _mapAlphaParticlesToNodes = new HashMap();
    private HashMap _mapNucleiToNodes = new HashMap();
    private GrabbableNucleusImageNode.Listener _grabbableNodeListener;
    private Random _rand = new Random();
    private AtomicNucleus.Listener _listenerAdapter;
    private PNode _nucleiLayer;
    private PNode _chartLayer;
    private Rectangle2D _nucleusPlacementAreaRect = new Rectangle2D.Double();
    private Rectangle2D _paddedBucketRect = new Rectangle2D.Double();
    private Rectangle2D _paddedResetButtonRect = new Rectangle2D.Double();

    public MultiNucleusAlphaDecayCanvas(MultiNucleusAlphaDecayModel multiNucleusAlphaDecayModel) {
        this._model = multiNucleusAlphaDecayModel;
        this.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, new PDimension(200.0, 150.0)){

            protected AffineTransform getPreprocessedTransform() {
                return AffineTransform.getTranslateInstance((double)MultiNucleusAlphaDecayCanvas.this.getWidth() * 0.5, (double)MultiNucleusAlphaDecayCanvas.this.getHeight() * 0.45);
            }
        });
        this.setBackground(NuclearPhysicsConstants.CANVAS_BACKGROUND);
        this._model.addListener(new NuclearDecayListenerAdapter(){

            public void modelElementAdded(Object object) {
                MultiNucleusAlphaDecayCanvas.this.handleModelElementAdded(object);
            }

            public void modelElementRemoved(Object object) {
                MultiNucleusAlphaDecayCanvas.this.handleModelElementRemoved(object);
            }

            public void nucleusTypeChanged() {
                MultiNucleusAlphaDecayCanvas.this.handleNucleusTypeChanged();
            }
        });
        this._nucleiLayer = new PNode();
        this.addWorldChild(this._nucleiLayer);
        this._chartLayer = new PNode();
        this.addScreenChild(this._chartLayer);
        this._resetButtonNode = new AutoPressButtonNode(NuclearPhysicsStrings.RESET_ALL_NUCLEI, 22, CANVAS_BUTTON_COLOR);
        this._chartLayer.addChild(this._resetButtonNode);
        this._resetButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiNucleusAlphaDecayCanvas.this.resetAllNuclei();
            }
        });
        this._decayTimeChart = new MultiNucleusDecayLinearTimeChart(this._model, this, AtomicNucleusImageType.NUCLEONS_VISIBLE, MultiNucleusDecayLinearTimeChart.YAxisLabelMode.ATOMIC_WEIGHT);
        this._decayTimeChart.setTimeSpan(3200.0);
        this._chartLayer.addChild(this._decayTimeChart);
        this._bucketRect = this._model.getBucketRectRef();
        this._bucketNode = new BucketOfNucleiNode(this._bucketRect.getWidth(), this._bucketRect.getHeight());
        this._nucleiLayer.addChild(this._bucketNode);
        this._bucketNode.setOffset(this._bucketRect.getX(), this._bucketRect.getY());
        this._addTenButtonNode = new HTMLImageButtonNode(NuclearPhysicsStrings.ADD_TEN, new PhetFont(1, 12), CANVAS_BUTTON_COLOR);
        double d = this._bucketRect.getWidth() / this._addTenButtonNode.getFullBoundsReference().width * 0.4;
        this._addTenButtonNode.scale(d);
        this._addTenButtonNode.setOffset(this._bucketRect.getCenterX() - this._addTenButtonNode.getFullBoundsReference().width / 2.0, this._bucketRect.getMaxY());
        this._nucleiLayer.addChild(this._addTenButtonNode);
        this._addTenButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiNucleusAlphaDecayCanvas.this.addMultipleNucleiFromBucket(10);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MultiNucleusAlphaDecayCanvas.this.update();
            }
        });
        this._grabbableNodeListener = new GrabbableNucleusImageNode.Listener(){

            public void nodeGrabbed(GrabbableNucleusImageNode grabbableNucleusImageNode) {
                MultiNucleusAlphaDecayCanvas.this.handleNodeGrabbed(grabbableNucleusImageNode);
            }

            public void nodeReleased(GrabbableNucleusImageNode grabbableNucleusImageNode) {
                MultiNucleusAlphaDecayCanvas.this.handleNodeReleased(grabbableNucleusImageNode);
            }
        };
        NucleusImageFactory.getInstance().preGenerateNucleusImages(83, 125, 25.0);
        NucleusImageFactory.getInstance().preGenerateNucleusImages(82, 125, 25.0);
    }

    public void update() {
        super.update();
        this._decayTimeChart.componentResized(new PDimension((double)this.getWidth() * 0.95, (double)this.getHeight() * 0.23));
        this._decayTimeChart.setOffset((double)(this.getWidth() / 2) - this._decayTimeChart.getFullBoundsReference().getWidth() / 2.0 - 3.0, 0.0);
        this._resetButtonNode.setOffset(0.82 * (double)this.getWidth() - this._resetButtonNode.getFullBoundsReference().width / 2.0, 0.3 * (double)this.getHeight());
        PDimension pDimension = new PDimension(this._decayTimeChart.getFullBoundsReference().width, this._decayTimeChart.getFullBoundsReference().height);
        this.getPhetRootNode().screenToWorld(pDimension);
        Dimension2D dimension2D = this.getWorldSize();
        double d = -dimension2D.getWidth() * 0.5 + 10.0;
        double d2 = dimension2D.getWidth() - 20.0;
        double d3 = -dimension2D.getHeight() * 0.45 + ((Dimension2D)pDimension).getHeight() + 10.0;
        double d4 = dimension2D.getHeight() - ((Dimension2D)pDimension).getHeight() - 20.0;
        this._nucleusPlacementAreaRect.setRect(d, d3, d2, d4);
        PDimension pDimension2 = new PDimension(this._resetButtonNode.getFullBoundsReference().width, this._resetButtonNode.getFullBoundsReference().height);
        this.getPhetRootNode().screenToWorld(pDimension2);
        Point2D point2D = this._resetButtonNode.getOffset();
        this.getPhetRootNode().screenToWorld(point2D);
        d = point2D.getX() - 10.0;
        d2 = ((Dimension2D)pDimension2).getWidth() + 20.0;
        d3 = point2D.getY() - 10.0;
        d4 = ((Dimension2D)pDimension2).getHeight() + 20.0;
        this._paddedResetButtonRect.setRect(d, d3, d2, d4);
        d = this._bucketRect.getX() - 10.0;
        d2 = this._bucketRect.getWidth() + 20.0;
        d3 = this._bucketRect.getY() - 10.0;
        d4 = this._bucketRect.getHeight() + 30.0;
        this._paddedBucketRect.setRect(d, d3, d2, d4);
    }

    public void autoPressResetNucleiButton() {
        this._resetButtonNode.autoPress();
    }

    private void handleModelElementAdded(Object object) {
        if (object instanceof AtomicNucleus) {
            GrabbableNucleusImageNode grabbableNucleusImageNode = new GrabbableNucleusImageNode((AtomicNucleus)object, AtomicNucleusImageType.NUCLEONS_VISIBLE, new LabelVisibilityModel());
            this._mapNucleiToNodes.put(object, grabbableNucleusImageNode);
            if (this.isNucleusPosInBucketRectangle((AtomicNucleus)object)) {
                grabbableNucleusImageNode.scale(0.6);
                this._bucketNode.addNucleus(grabbableNucleusImageNode);
            }
            grabbableNucleusImageNode.addListener(this._grabbableNodeListener);
        } else if (object instanceof AlphaParticle) {
            AlphaParticleModelNode alphaParticleModelNode = new AlphaParticleModelNode((AlphaParticle)object);
            this._nucleiLayer.addChild(alphaParticleModelNode);
            this._mapAlphaParticlesToNodes.put(object, alphaParticleModelNode);
        } else {
            System.err.println("WARNING: Unrecognized model element added, unable to create node for canvas.");
        }
    }

    private void handleModelElementRemoved(Object object) {
        if (object instanceof AtomicNucleus) {
            AbstractAtomicNucleusNode abstractAtomicNucleusNode = (AbstractAtomicNucleusNode)this._mapNucleiToNodes.get(object);
            if (abstractAtomicNucleusNode == null) {
                System.err.println("Error: Could not find node for removed model element.");
            } else {
                ((AtomicNucleus)object).removeListener(this._listenerAdapter);
                if (this._bucketNode.isNodeInBucket(abstractAtomicNucleusNode)) {
                    this._bucketNode.removeNucleus(abstractAtomicNucleusNode);
                } else {
                    this.removeWorldChild(abstractAtomicNucleusNode);
                }
            }
            this._mapNucleiToNodes.remove(object);
        } else if (object instanceof AlphaParticle) {
            AlphaParticleModelNode alphaParticleModelNode = (AlphaParticleModelNode)this._mapAlphaParticlesToNodes.get(object);
            if (alphaParticleModelNode == null) {
                System.err.println("Error: Could not find node for removed alpha particle.");
            } else {
                this.removeWorldChild(alphaParticleModelNode);
            }
            this._mapAlphaParticlesToNodes.remove(object);
        }
    }

    private void handleNucleusTypeChanged() {
        this._bucketNode.setNucleusType(this._model.getNucleusType());
    }

    private void resetAllNuclei() {
        Set set = this._mapNucleiToNodes.entrySet();
        for (Map.Entry entry : set) {
            AtomicNucleus atomicNucleus = (AtomicNucleus)entry.getKey();
            atomicNucleus.reset();
            if (this._bucketNode.isNodeInBucket((AbstractAtomicNucleusNode)this._mapNucleiToNodes.get(atomicNucleus)) || !(atomicNucleus instanceof NuclearDecayControl)) continue;
            atomicNucleus.activateDecay();
        }
    }

    public void reset() {
        this._decayTimeChart.reset();
    }

    private boolean isNucleusPosInBucketRectangle(AtomicNucleus atomicNucleus) {
        return this._bucketRect.contains(atomicNucleus.getPositionReference());
    }

    private void transferNodeFromBucketToCanvas(AbstractAtomicNucleusNode abstractAtomicNucleusNode) {
        this._nucleiLayer.addChild(abstractAtomicNucleusNode);
        abstractAtomicNucleusNode.setScale(1.0);
    }

    private void transferNodeFromCanvasToBucket(AbstractAtomicNucleusNode abstractAtomicNucleusNode) {
        abstractAtomicNucleusNode.getNucleusRef().reset();
        this._bucketNode.addNucleusAnimated(abstractAtomicNucleusNode);
    }

    private void handleNodeGrabbed(GrabbableNucleusImageNode grabbableNucleusImageNode) {
        if (this._bucketNode.isNodeInBucket(grabbableNucleusImageNode)) {
            this._bucketNode.removeNucleus(grabbableNucleusImageNode);
            this.transferNodeFromBucketToCanvas(grabbableNucleusImageNode);
        } else {
            grabbableNucleusImageNode.getNucleusRef().setPaused(true);
        }
    }

    private void handleNodeReleased(GrabbableNucleusImageNode grabbableNucleusImageNode) {
        if (this.isNucleusPosInBucketRectangle(grabbableNucleusImageNode.getNucleusRef())) {
            this.transferNodeFromCanvasToBucket(grabbableNucleusImageNode);
        } else {
            AtomicNucleus atomicNucleus = grabbableNucleusImageNode.getNucleusRef();
            if (atomicNucleus.isPaused()) {
                atomicNucleus.setPaused(false);
            } else {
                atomicNucleus.activateDecay();
            }
        }
    }

    private Point2D findOpenSpotForNucleus(AbstractAtomicNucleusNode abstractAtomicNucleusNode) {
        boolean bl = false;
        Point2D.Double double_ = new Point2D.Double();
        for (int i = 0; i < 3 && !bl; ++i) {
            double d = 15.0;
            if (i == 1) {
                d = 7.5;
            } else if (i == 3) {
                d = 0.0;
                System.err.println("WARNING: Allowing nucleus to overlap with others.");
            }
            int n = 0;
            while (n < 100 & !bl) {
                double d2 = this._nucleusPlacementAreaRect.getX() + this._rand.nextDouble() * this._nucleusPlacementAreaRect.getWidth();
                double d3 = this._nucleusPlacementAreaRect.getY() + this._rand.nextDouble() * this._nucleusPlacementAreaRect.getHeight();
                ((Point2D)double_).setLocation(d2, d3);
                bl = true;
                if (this._paddedResetButtonRect.contains(double_)) {
                    bl = false;
                } else if (this._paddedBucketRect.contains(double_)) {
                    bl = false;
                } else {
                    AtomicNucleus atomicNucleus = abstractAtomicNucleusNode.getNucleusRef();
                    Set set = this._mapNucleiToNodes.entrySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext() && bl) {
                        Map.Entry entry = iterator.next();
                        AtomicNucleus atomicNucleus2 = (AtomicNucleus)entry.getKey();
                        if (this._bucketNode.isNodeInBucket((AbstractAtomicNucleusNode)this._mapNucleiToNodes.get(atomicNucleus2)) || atomicNucleus == atomicNucleus2 || !(double_.distance(atomicNucleus2.getPositionReference()) < d)) continue;
                        bl = false;
                        break;
                    }
                }
                ++n;
            }
        }
        return double_;
    }

    private int addMultipleNucleiFromBucket(int n) {
        AbstractAtomicNucleusNode abstractAtomicNucleusNode;
        int n2;
        for (n2 = 0; n2 < n && (abstractAtomicNucleusNode = this._bucketNode.extractAnyNucleusFromBucket()) != null; ++n2) {
            this.transferNodeFromBucketToCanvas(abstractAtomicNucleusNode);
            abstractAtomicNucleusNode.getNucleusRef().setPosition(this.findOpenSpotForNucleus(abstractAtomicNucleusNode));
            AtomicNucleus atomicNucleus = abstractAtomicNucleusNode.getNucleusRef();
            if (!(atomicNucleus instanceof NuclearDecayControl)) continue;
            atomicNucleus.activateDecay();
        }
        return n2;
    }
}

