/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import java.awt.geom.Point2D;

public class Uranium238Nucleus
extends AtomicNucleus {
    public static double HALF_LIFE = 1.41E20;
    private static double DECAY_TIME_SCALING_FACTOR = 2500.0 / HALF_LIFE;

    public Uranium238Nucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D) {
        super(nuclearPhysicsClock, point2D, 92, 146, DECAY_TIME_SCALING_FACTOR);
    }

    public Uranium238Nucleus(NuclearPhysicsClock nuclearPhysicsClock) {
        this(nuclearPhysicsClock, new Point2D.Double(0.0, 0.0));
    }

    public double getHalfLife() {
        return HALF_LIFE;
    }

    public boolean captureParticle(Nucleon nucleon) {
        boolean bl = false;
        if (nucleon instanceof Nucleon && nucleon.getNucleonType() == Nucleon.NucleonType.NEUTRON && this._numNeutrons == 146) {
            ++this._numNeutrons;
            this.notifyNucleusChangeEvent(null);
            bl = true;
        }
        return bl;
    }

    public void reset() {
        super.reset();
        if (this._numNeutrons != 146 || this._numProtons != 92) {
            this._numNeutrons = 146;
            this._numProtons = 92;
            this.notifyNucleusChangeEvent(null);
        }
    }

    public void activateDecay() {
        if (this._numNeutrons == 146) {
            this._decayTime = this._clock.getSimulationTime() + this.calcDecayTime() * this._decayTimeScalingFactor;
        }
    }

    protected void decay(ClockEvent clockEvent) {
        this._numNeutrons -= 22;
        this._numProtons -= 10;
        this._activatedLifetime += clockEvent.getSimulationTimeChange();
        this.notifyNucleusChangeEvent(null);
        this._decayTime = 0.0;
    }
}

