/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.model.AbstractBetaDecayNucleus;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import java.awt.geom.Point2D;

public class LightAdjustableHalfLifeNucleus
extends AbstractBetaDecayNucleus {
    private static double DECAY_TIME_SCALING_FACTOR = 1500.0 / HalfLifeInfo.getHalfLifeForNucleusType(NucleusType.LIGHT_CUSTOM);

    public LightAdjustableHalfLifeNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D, boolean bl) {
        super(nuclearPhysicsClock, point2D, 8, 8, DECAY_TIME_SCALING_FACTOR);
    }

    public LightAdjustableHalfLifeNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D) {
        this(nuclearPhysicsClock, point2D, false);
    }

    public LightAdjustableHalfLifeNucleus(NuclearPhysicsClock nuclearPhysicsClock) {
        this(nuclearPhysicsClock, new Point2D.Double(0.0, 0.0));
    }

    public void reset() {
        super.reset();
        if (this._numNeutrons != 8 || this._numProtons != 8) {
            this._numNeutrons = 8;
            this._numProtons = 8;
            this.notifyNucleusChangeEvent(null);
        }
        this.notifyPositionChanged();
    }
}

