/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.model.BetaDecayCompositeNucleus;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import java.awt.geom.Point2D;

public class Hydrogen3CompositeNucleus
extends BetaDecayCompositeNucleus {
    private static double DECAY_TIME_SCALING_FACTOR = 500.0 / HalfLifeInfo.getHalfLifeForNucleusType(NucleusType.HYDROGEN_3);

    public Hydrogen3CompositeNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D) {
        super(nuclearPhysicsClock, point2D, 1, 2, DECAY_TIME_SCALING_FACTOR);
    }

    protected void updateAgitationFactor() {
        switch (this._numProtons) {
            case 1: {
                if (this._numNeutrons != 2) break;
                this._agitationFactor = 8;
                break;
            }
            case 2: {
                if (this._numNeutrons != 1) break;
                this._agitationFactor = 2;
                break;
            }
            default: {
                System.err.println("Error: Unexpected atomic weight in beta decay nucleus.");
                assert (false);
                break;
            }
        }
    }
}

