/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;

public class HalfLifeInfo {
    private HalfLifeInfo() {
    }

    public static double getHalfLifeForNucleusType(NucleusType nucleusType) {
        double d;
        if (nucleusType == null) {
            return Double.POSITIVE_INFINITY;
        }
        switch (nucleusType) {
            case HYDROGEN_3: {
                d = HalfLifeInfo.convertDaysToMs(4500.0);
                break;
            }
            case CARBON_14: {
                d = HalfLifeInfo.convertYearsToMs(5730.0);
                break;
            }
            case LIGHT_CUSTOM: {
                d = HalfLifeInfo.convertYearsToMs(11.0);
                break;
            }
            case POLONIUM_211: {
                d = 516.0;
                break;
            }
            case URANIUM_235: {
                d = HalfLifeInfo.convertYearsToMs(7.038E8);
                break;
            }
            case URANIUM_238: {
                d = HalfLifeInfo.convertYearsToMs(4.46E9);
                break;
            }
            case HEAVY_CUSTOM: {
                d = 900.0;
                break;
            }
            default: {
                System.err.println("Warning: No half life info for nucleus type " + (Object)((Object)nucleusType));
                assert (false);
                d = 0.0;
            }
        }
        return d;
    }

    public static double getHalfLifeForNucleusConfig(int n, int n2) {
        return HalfLifeInfo.getHalfLifeForNucleusType(AtomicNucleus.identifyNucleus(n, n2));
    }

    public static double convertYearsToMs(double d) {
        return d * 3.1556926E10;
    }

    public static double convertMsToYears(double d) {
        return d * 3.16887646E-11;
    }

    public static double convertDaysToMs(double d) {
        return d * 8.64E7;
    }

    public static double convertHoursToMs(double d) {
        return d * 3600000.0;
    }
}

