/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.common.view;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.view.AtomicNucleusImageNode;
import edu.colorado.phet.nuclearphysics.common.view.AtomicNucleusImageType;
import edu.colorado.phet.nuclearphysics.module.betadecay.LabelVisibilityModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import java.util.ArrayList;

public class GrabbableNucleusImageNode
extends AtomicNucleusImageNode {
    private ArrayList _listeners = new ArrayList();

    public GrabbableNucleusImageNode(AtomicNucleus atomicNucleus, AtomicNucleusImageType atomicNucleusImageType, LabelVisibilityModel labelVisibilityModel) {
        super(atomicNucleus, atomicNucleusImageType, labelVisibilityModel);
        this.setPickable(true);
        this.setChildrenPickable(true);
        this.addInputEventListener(new CursorHandler(CursorHandler.HAND));
        this.addInputEventListener(new PDragEventHandler(){

            public void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                GrabbableNucleusImageNode.this.handleMouseStartDragEvent(pInputEvent);
            }

            public void drag(PInputEvent pInputEvent) {
                GrabbableNucleusImageNode.this.handleMouseDragEvent(pInputEvent);
            }

            public void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                GrabbableNucleusImageNode.this.handleMouseEndDragEvent(pInputEvent);
            }
        });
    }

    public void addListener(Listener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    private void handleMouseStartDragEvent(PInputEvent pInputEvent) {
        this.notifyNodeGrabbed();
    }

    private void handleMouseDragEvent(PInputEvent pInputEvent) {
        PNode pNode = pInputEvent.getPickedNode();
        PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode);
        pNode.localToParent(pDimension);
        AtomicNucleus atomicNucleus = this.getNucleusRef();
        double d = atomicNucleus.getPositionReference().getX() + pDimension.getWidth();
        double d2 = atomicNucleus.getPositionReference().getY() + pDimension.getHeight();
        atomicNucleus.setPosition(d, d2);
    }

    private void handleMouseEndDragEvent(PInputEvent pInputEvent) {
        this.notifyNodeReleased();
    }

    private void notifyNodeReleased() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).nodeReleased(this);
        }
    }

    private void notifyNodeGrabbed() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).nodeGrabbed(this);
        }
    }

    public static interface Listener {
        public void nodeGrabbed(GrabbableNucleusImageNode var1);

        public void nodeReleased(GrabbableNucleusImageNode var1);
    }
}

