/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.common.model;

import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class SubatomicParticle {
    protected ArrayList<Listener> _listeners = new ArrayList();
    private Point2D.Double _position;
    private double _xVelocity;
    private double _yVelocity;
    private double _xAcceleration;
    private double _yAcceleration;

    public SubatomicParticle(double d, double d2, double d3, double d4) {
        this._position = new Point2D.Double(d, d2);
        this._xVelocity = d3;
        this._yVelocity = d4;
    }

    public SubatomicParticle(double d, double d2) {
        this(d, d2, 0.0, 0.0);
    }

    public Point2D.Double getPosition() {
        return new Point2D.Double(this._position.getX(), this._position.getY());
    }

    public Point2D.Double getPositionReference() {
        return this._position;
    }

    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public void setPosition(double d, double d2) {
        this._position.setLocation(d, d2);
        this.notifyPositionChanged();
    }

    public void setVelocity(double d, double d2) {
        this._xVelocity = d;
        this._yVelocity = d2;
    }

    public void setAcceleration(double d, double d2) {
        this._xAcceleration = d;
        this._yAcceleration = d2;
    }

    protected void notifyPositionChanged() {
        for (Listener listener : this._listeners) {
            listener.positionChanged(this);
        }
    }

    public void translate() {
        this._position.x += this._xVelocity;
        this._position.y += this._yVelocity;
        this.notifyPositionChanged();
        this._xVelocity += this._xAcceleration;
        this._yVelocity += this._yAcceleration;
    }

    public void tunnel(Point2D point2D, double d, double d2, double d3) {
    }

    public void jitter() {
    }

    public void addListener(Listener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this._listeners.remove(listener);
    }

    public static interface Listener {
        public void positionChanged(SubatomicParticle var1);
    }
}

