/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics;

import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class NuclearPhysicsConstants {
    public static final FrameSetup FRAME_SETUP = new FrameSetup.CenteredWithSize(1024, 768);
    public static final String DEFAULT_FONT_NAME = PhetFont.getDefaultFontName();
    public static final Font CONTROL_PANEL_TITLE_FONT = new Font(DEFAULT_FONT_NAME, 1, 12);
    public static final Font CONTROL_PANEL_CONTROL_FONT = new Font(DEFAULT_FONT_NAME, 0, 12);
    public static final Font PLAY_AREA_TITLE_FONT = new Font(DEFAULT_FONT_NAME, 1, 16);
    public static final Font PLAY_AREA_CONTROL_FONT = new Font(DEFAULT_FONT_NAME, 0, 16);
    public static final Stroke DASHED_STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    public static final Color CANVAS_BACKGROUND = Color.WHITE;
    public static final Color CANVAS_LABELS_COLOR = Color.BLACK;
    public static final Color NUCLEAR_FISSION_CONTROL_PANEL_COLOR = new Color(16775885);
    public static final Color ALPHA_DECAY_CONTROL_PANEL_COLOR = new Color(227, 239, 214);
    public static final Color BETA_DECAY_CONTROL_PANEL_COLOR = new Color(227, 239, 214);
    public static final Color RADIOACTIVE_DATING_GAME_CONTROL_PANEL_COLOR = new Color(227, 239, 214);
    public static final Color COLOR_TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Color POLONIUM_LABEL_COLOR = Color.YELLOW;
    public static final Color LEAD_LABEL_COLOR = Color.BLACK;
    public static final Color CUSTOM_NUCLEUS_LABEL_COLOR = new Color(0x99FFFF);
    public static final Color CUSTOM_NUCLEUS_POST_DECAY_LABEL_COLOR = Color.BLACK;
    public static final Color HYDROGEN_3_LABEL_COLOR = new Color(127, 255, 0);
    public static final Color HELIUM_3_LABEL_COLOR = new Color(255, 192, 203);
    public static final Color CARBON_14_LABEL_COLOR = Color.YELLOW;
    public static final Color NITROGEN_14_LABEL_COLOR = Color.ORANGE;
    public static final Color URANIUM_235_LABEL_COLOR = Color.GREEN;
    public static final Color URANIUM_236_LABEL_COLOR = Color.ORANGE;
    public static final Color URANIUM_238_LABEL_COLOR = Color.YELLOW;
    public static final Color URANIUM_239_LABEL_COLOR = Color.WHITE;
    public static final Color HYDROGEN_COLOR = Color.PINK;
    public static final Color HELIUM_COLOR = Color.CYAN;
    public static final Color CARBON_COLOR = new Color(200, 0, 0);
    public static final Color NITROGEN_COLOR = new Color(14, 86, 200);
    public static final Color URANIUM_COLOR = new Color(150, 150, 0);
    public static final Color LEAD_COLOR = new Color(97, 117, 126);
    public static final Color POLONIUM_COLOR = Color.ORANGE;
    public static final Color CUSTOM_NUCLEUS_PRE_DECAY_COLOR = new Color(155, 97, 42);
    public static final Color CUSTOM_NUCLEUS_POST_DECAY_COLOR = new Color(54, 130, 55);
    public static final Color CHART_BACKGROUND_COLOR = new Color(246, 242, 175);
    public static final Color CANVAS_RESET_BUTTON_COLOR = new Color(0xFF9900);
    public static final ArrayList<Color> strataColors = new ArrayList();
    public static final Color PROTON_COLOR;
    public static final Color PROTON_HILITE_COLOR;
    public static final Color NEUTRON_COLOR;
    public static final Color NEUTRON_HILITE_COLOR;
    public static final Color ELECTRON_COLOR;
    public static final Color ELECTRON_HILITE_COLOR;
    public static final Paint PROTON_ROUND_GRADIENT;
    public static final Paint NEUTRON_ROUND_GRADIENT;
    public static final Paint ELECTRON_ROUND_GRADIENT;
    public static final Color ANTINEUTRINO_COLOR;
    public static final double DEFAULT_CUSTOM_NUCLEUS_HALF_LIFE;

    static {
        strataColors.add(new Color(111, 131, 151));
        strataColors.add(new Color(153, 185, 216));
        strataColors.add(new Color(216, 175, 208));
        strataColors.add(new Color(198, 218, 119));
        strataColors.add(new Color(179, 179, 179));
        strataColors.add(Color.DARK_GRAY);
        PROTON_COLOR = new Color(0xAA0000);
        PROTON_HILITE_COLOR = new Color(0xFFAAAA);
        NEUTRON_COLOR = Color.GRAY;
        NEUTRON_HILITE_COLOR = new Color(0xEEEEEE);
        ELECTRON_COLOR = Color.BLUE;
        ELECTRON_HILITE_COLOR = Color.CYAN;
        PROTON_ROUND_GRADIENT = new RoundGradientPaint(-0.26666666666666666, -0.26666666666666666, PROTON_HILITE_COLOR, new Point2D.Double(0.4, 0.4), PROTON_COLOR);
        NEUTRON_ROUND_GRADIENT = new RoundGradientPaint(-0.26666666666666666, -0.26666666666666666, NEUTRON_HILITE_COLOR, new Point2D.Double(0.4, 0.4), NEUTRON_COLOR);
        ELECTRON_ROUND_GRADIENT = new RoundGradientPaint(-0.125, -0.125, ELECTRON_HILITE_COLOR, new Point2D.Double(0.1875, 0.1875), ELECTRON_COLOR);
        ANTINEUTRINO_COLOR = new Color(0, 220, 0);
        DEFAULT_CUSTOM_NUCLEUS_HALF_LIFE = HalfLifeInfo.convertYearsToMs(100000.0);
    }
}

