/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.module.chainreaction.ChainReactionModule;
import edu.colorado.phet.nuclearphysics.module.fissiononenucleus.FissionOneNucleusModule;
import edu.colorado.phet.nuclearphysics.module.nuclearreactor.NuclearReactorModule;

public class NuclearFissionApplication
extends PiccoloPhetApplication {
    private FissionOneNucleusModule _fissionOneNucleusModule;
    private ChainReactionModule _chainReactionModule;
    private NuclearReactorModule _nuclearReactorModule;

    public NuclearFissionApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        PhetFrame phetFrame = this.getPhetFrame();
        this._fissionOneNucleusModule = new FissionOneNucleusModule(phetFrame);
        this.addModule(this._fissionOneNucleusModule);
        this._chainReactionModule = new ChainReactionModule(phetFrame);
        this.addModule(this._chainReactionModule);
        this._nuclearReactorModule = new NuclearReactorModule(phetFrame);
        this.addModule(this._nuclearReactorModule);
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new NuclearFissionApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "nuclear-physics", "nuclear-fission");
        PhetLookAndFeel phetLookAndFeel = new PhetLookAndFeel();
        phetLookAndFeel.setBackgroundColor(NuclearPhysicsConstants.NUCLEAR_FISSION_CONTROL_PANEL_COLOR);
        phetApplicationConfig.setLookAndFeel(phetLookAndFeel);
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

