/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.preferences;

import edu.colorado.phet.common.phetcommon.preferences.PhetPreferences;
import edu.colorado.phet.common.phetcommon.preferences.StatisticsDetailsDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.statistics.SessionMessage;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PrivacyPreferencesPanel
extends JPanel {
    private static final String STATISTICS_ENABLED = PhetCommonResources.getString("Common.statistics.enabled");
    private final PhetPreferences preferences;
    private final JCheckBox statisticsEnabledCheckBox;
    private final JCheckBox alwaysShowSoftwareAgreementCheckBox;

    public PrivacyPreferencesPanel(PhetPreferences phetPreferences, SessionMessage sessionMessage, boolean bl) {
        this.preferences = phetPreferences;
        DescriptionPane descriptionPane = new DescriptionPane(sessionMessage);
        this.statisticsEnabledCheckBox = new JCheckBox(STATISTICS_ENABLED, phetPreferences.isStatisticsEnabled());
        this.alwaysShowSoftwareAgreementCheckBox = new JCheckBox("Always show Software Agreement (dev)", phetPreferences.isAlwaysShowSoftwareAgreement());
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setInsets(new Insets(5, 5, 5, 5));
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(descriptionPane, n++, n2);
        easyGridBagLayout.addComponent(this.statisticsEnabledCheckBox, n++, n2);
        if (bl) {
            easyGridBagLayout.addComponent(this.alwaysShowSoftwareAgreementCheckBox, n++, n2);
        }
    }

    public void save() {
        this.preferences.setStatisticsEnabled(this.statisticsEnabledCheckBox.isSelected());
        this.preferences.setAlwaysShowSoftwareAgreement(this.alwaysShowSoftwareAgreementCheckBox.isSelected());
    }

    private static class DescriptionPane
    extends HTMLUtils.HTMLEditorPane {
        private static final String DESCRIPTION_PATTERN = PhetCommonResources.getString("Common.statistics.description");

        public DescriptionPane(final SessionMessage sessionMessage) {
            super("");
            Object[] objectArray = new Object[]{"showStatisticsDetails"};
            String string = MessageFormat.format(DESCRIPTION_PATTERN, objectArray);
            this.setText(HTMLUtils.createStyledHTMLFromFragment(string));
            this.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (hyperlinkEvent.getDescription().equals("showStatisticsDetails")) {
                            DescriptionPane.showStatisticsDetails(SwingUtilities.getWindowAncestor(DescriptionPane.this), sessionMessage);
                        } else {
                            System.err.println("PrivacyPreferencesPanel.DescriptionPane.hyperlinkUpdate: unsupported hyperlink, description=" + hyperlinkEvent.getDescription());
                        }
                    }
                }
            });
            this.setBackground(new JPanel().getBackground());
        }

        private static void showStatisticsDetails(Window window, SessionMessage sessionMessage) {
            if (window instanceof Frame) {
                new StatisticsDetailsDialog((Frame)window, sessionMessage).setVisible(true);
            } else if (window instanceof Dialog) {
                new StatisticsDetailsDialog((Dialog)window, sessionMessage).setVisible(true);
            }
        }
    }
}

