/*
  Connect ESP32 to AskSensors
 * Description:  This sketch connects to a website (https://asksensors.com) using an ESP32 Wifi module.
 *  Author: https://asksensors.com, 2018
 *  github: https://github.com/asksensors
 */

 /* 
 *  Tämä on harjoitustyö JYU TIES536 Suolautettu Internet -kurssille 
 *  Työssä on toteutettu ESP32 alustalle ohjelma, joka lukee lämpötilan, paineen, kosteuden,
 *  valoisuuden ja tunnistaa liikkeen sensoreidensa avulla. ESP32 lähettää WiFi:n kautta 
 *  lukemansa tiedot AskSensor-pilveen. Pilvessä tulokset on saatavilla viivagraafeina, 
 *  taulukkoina ja liiketieto binaareina. 
 */
 
#include <WiFi.h>
#include <WiFiMulti.h>
#include <HTTPClient.h>

#include <Adafruit_Sensor.h>
#include <Adafruit_BME280.h>
#define SEALEVELPRESSURE_HPA (1013.25)
#define LIGHTSENSORPIN 34 //Valosensori pinnissä 34

Adafruit_BME280 bme; //BME280 esittely
int reading;
byte sensorPin = 27;  //liikesensorin esittely

WiFiMulti WiFiMulti;
HTTPClient ask;
// TODO: user config
const char* ssid     = "........."; //täydennä Wifi SSID
const char* password = "........."; //täydennä Wifi Password
const char* apiKeyIn1 = "9UYpaUcJVLbmKv1MLxmzKWjUlhhVw91m";      // API KEY 1 IN
const char* apiKeyIn2 = "hTtwBkYLBTrhJNXp7xP3Tdc9N7TwxUJT";      // API KEY 2 IN
const unsigned int writeInterval = 60000;   // write interval (in ms)

// ASKSENSORS API host config
const char* host = "api.asksensors.com";  // API host name
const int httpPort = 80;      // port
  
void setup(){
  
  // open serial
  Serial.begin(115200);
  Serial.println("*****************************************************");
  Serial.println("********** Program Start : Connect ESP32 to AskSensors.");
  Serial.println("Wait for WiFi... ");

  pinMode(LIGHTSENSORPIN, INPUT);
  byte sensorPin = 27; //liikesensorin aktivointi

  // connecting to the WiFi network
  WiFiMulti.addAP(ssid, password);
  while (WiFiMulti.run() != WL_CONNECTED) {
    Serial.print(".");
    delay(500);
  }
  // connected
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());

  //BME280 käynnistys
  while(!Serial);
  Serial.println(F("BME280 test"));
  bme.begin();
}


void loop(){

  // Use WiFiClient class to create TCP connections
  WiFiClient client;


  if (!client.connect(host, httpPort)) {
    Serial.println("connection failed");
    return;
  }else {

    sensori1(); //kutsutaan sensori 1 varten aliohjelmaa
    sensori2(); //kutsutaan sensori 2 varten aliohjelmaa

  }

  client.stop();  // stop client
  
  delay(writeInterval);    // delay
}

//aliohjelma sensori 1 datankeruuta varten
void sensori1 () {   
  
  // Create a URL for updating module1 and module 2
  String url = "http://api.asksensors.com/write/";
  url += apiKeyIn1;
  url += "?module1="; //lampotila viivana
  url += bme.readTemperature();
  url += "&module2="; //kosteus
  url += bme.readHumidity(); 
  url += "&module3="; //lampotila taulukossa
  url += bme.readTemperature();
  url += "&module4="; //ilmanpaine
  url += bme.readPressure()/100.0F;
    
  Serial.print("********** requesting URL: ");
  Serial.println(url);
   // send data 
   ask.begin(url); //Specify the URL
  
    //Check for the returning code
    int httpCode = ask.GET();          
 
    if (httpCode > 0) { 
 
        String payload = ask.getString();
        Serial.println(httpCode);
        Serial.println(payload);
      } else {
      Serial.println("Error on HTTP request");
    }
 
    ask.end(); //End 
    Serial.println("********** End ");
    Serial.println("*****************************************************");
}    

//aliohjelma sensori 2 datankeruuta varten
void sensori2 () {   

  // Create a URL for updating module1 and module 2
  String url = "http://api.asksensors.com/write/";
  url += apiKeyIn2;
  url += "?module1="; //valoisuusarvot viivana
  url += analogRead(LIGHTSENSORPIN);
  url += "&module2="; //valoisuusarvot taulukkona
  url += analogRead(LIGHTSENSORPIN); 
  
  url += "&module3="; //onko havaittu liikettä
  url += digitalRead(sensorPin);
  url += "&module4="; //liikkeet taulukossa
  url += digitalRead(sensorPin);
    
  Serial.print("********** requesting URL: ");
  Serial.println(url);
   // send data 
   ask.begin(url); //Specify the URL
  
    //Check for the returning code
    int httpCode = ask.GET();          
 
    if (httpCode > 0) { 
 
        String payload = ask.getString();
        Serial.println(httpCode);
        Serial.println(payload);
      } else {
      Serial.println("Error on HTTP request");
    }
 
    ask.end(); //End 
    Serial.println("********** End ");
    Serial.println("*****************************************************");
}    
